/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.legacy.user.external.client.query;

import io.muenchendigital.digiwf.legacy.user.external.configuration.ServiceAuthLdapProperties;
import java.util.Arrays;
import java.util.List;
import org.springframework.ldap.filter.AndFilter;
import org.springframework.ldap.filter.BinaryLogicalFilter;
import org.springframework.ldap.filter.EqualsFilter;
import org.springframework.ldap.filter.Filter;
import org.springframework.ldap.filter.LikeFilter;
import org.springframework.ldap.filter.OrFilter;
import org.springframework.stereotype.Component;

@Component
public class LdapFilterFactory {
    private final ServiceAuthLdapProperties serviceAuthLdapProperties;

    public Filter createOuNameFilter(String ouName) {
        return new AndFilter().and((Filter)new EqualsFilter("ou", ouName)).and(this.createOuFilter());
    }

    public Filter createNamePatternFilter(String pattern) {
        return new OrFilter().append((Filter)new LikeFilter("givenName", this.createStartsWithExpression(pattern))).append((Filter)new LikeFilter("sn", this.createStartsWithExpression(pattern)));
    }

    public Filter createNamePatternsFilter(String firstPattern, String secondPattern) {
        BinaryLogicalFilter firstAndFilter = new AndFilter().append((Filter)new LikeFilter("givenName", this.createStartsWithExpression(firstPattern))).append((Filter)new LikeFilter("sn", this.createStartsWithExpression(secondPattern)));
        BinaryLogicalFilter secondAndFilter = new AndFilter().append((Filter)new LikeFilter("givenName", this.createStartsWithExpression(secondPattern))).append((Filter)new LikeFilter("sn", this.createStartsWithExpression(firstPattern)));
        return new OrFilter().append((Filter)firstAndFilter).append((Filter)secondAndFilter);
    }

    private String createStartsWithExpression(String pattern) {
        if (pattern.endsWith("*")) {
            return pattern;
        }
        return pattern + "*";
    }

    public Filter createOuNameFilter(List<String> ouNames) {
        OrFilter ouFilter = new OrFilter();
        ouNames.forEach(ou -> ouFilter.append((Filter)new EqualsFilter("ou", ou)));
        return ouFilter;
    }

    public Filter createPersonFilter() {
        return this.createObjectClassFilter(Arrays.asList(this.serviceAuthLdapProperties.getPersonObjectClasses().split(",")));
    }

    public Filter createOuFilter() {
        return this.createObjectClassFilter(Arrays.asList(this.serviceAuthLdapProperties.getOuObjectClasses().split(",")));
    }

    private Filter createObjectClassFilter(List<String> objectClasses) {
        AndFilter filter = new AndFilter();
        objectClasses.forEach(objectClass -> filter.append((Filter)new EqualsFilter("objectclass", objectClass)));
        return filter;
    }

    public LdapFilterFactory(ServiceAuthLdapProperties serviceAuthLdapProperties) {
        this.serviceAuthLdapProperties = serviceAuthLdapProperties;
    }
}

