/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.legacy.user.external.client.query;

import io.muenchendigital.digiwf.legacy.user.external.client.query.LdapFilterFactory;
import java.util.List;
import org.springframework.ldap.filter.AndFilter;
import org.springframework.ldap.filter.Filter;
import org.springframework.ldap.query.LdapQuery;
import org.springframework.ldap.query.LdapQueryBuilder;
import org.springframework.ldap.query.SearchScope;

public class LdapQueryFactory {
    private final LdapFilterFactory ldapFilterFactory;
    private final String personSearchBase;
    private final String ouSearchBase;

    public LdapQuery createPersonByIdQuery(String id) {
        return LdapQueryBuilder.query().searchScope(SearchScope.SUBTREE).base(this.personSearchBase).where("lhmObjectId").is(id);
    }

    public LdapQuery createPersonByUsernameQuery(String username) {
        return LdapQueryBuilder.query().searchScope(SearchScope.SUBTREE).base(this.personSearchBase).where("uid").is(username);
    }

    public LdapQuery createPersonByNamePatternAndOuQuery(String filter, List<String> ouFilters) {
        return LdapQueryBuilder.query().searchScope(SearchScope.SUBTREE).base(this.personSearchBase).filter((Filter)new AndFilter().append(this.ldapFilterFactory.createOuNameFilter(ouFilters)).append(this.ldapFilterFactory.createNamePatternFilter(filter)).append(this.ldapFilterFactory.createPersonFilter()));
    }

    public LdapQuery createPersonByNamePatternsAndOuQuery(String firstFilter, String secondFilter, List<String> ouFilters) {
        return LdapQueryBuilder.query().searchScope(SearchScope.SUBTREE).base(this.personSearchBase).filter((Filter)new AndFilter().append(this.ldapFilterFactory.createOuNameFilter(ouFilters)).append(this.ldapFilterFactory.createNamePatternsFilter(firstFilter, secondFilter)));
    }

    public LdapQuery createOuByNameAndParentPathQuery(String ouName, String parentPath) {
        return LdapQueryBuilder.query().searchScope(SearchScope.SUBTREE).base(parentPath).filter(this.ldapFilterFactory.createOuNameFilter(ouName));
    }

    public LdapQuery createOuByShortNameQuery(String shortName) {
        return LdapQueryBuilder.query().searchScope(SearchScope.SUBTREE).base(this.ouSearchBase).where("lhmOuShortName").is(shortName);
    }

    public LdapQuery createPersonByObjectIdQuery(String lhmObjectId) {
        return LdapQueryBuilder.query().searchScope(SearchScope.SUBTREE).base(this.personSearchBase).where("lhmObjectId").is(lhmObjectId);
    }

    public LdapQueryFactory(LdapFilterFactory ldapFilterFactory, String personSearchBase, String ouSearchBase) {
        this.ldapFilterFactory = ldapFilterFactory;
        this.personSearchBase = personSearchBase;
        this.ouSearchBase = ouSearchBase;
    }
}

