/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.message.api.streaming;

import io.muenchendigital.digiwf.asyncapi.docs.annotations.DocumentAsyncAPI;
import io.muenchendigital.digiwf.message.api.streaming.CorrelateMessageTOV01;
import io.muenchendigital.digiwf.message.api.streaming.MessageApiMapper;
import io.muenchendigital.digiwf.message.domain.service.MessageService;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.messaging.Message;
import org.springframework.stereotype.Component;

@Component
public class MessageEventListener {
    private static final Logger log = LoggerFactory.getLogger(MessageEventListener.class);
    private final MessageService messageService;
    private final MessageApiMapper messageApiMapper;

    @DocumentAsyncAPI(payload=CorrelateMessageTOV01.class, functionRouter=true, typeHeader="correlateMessageV01")
    @Bean
    public Consumer<Message<CorrelateMessageTOV01>> correlateMessageV01() {
        return correlation -> {
            log.info("Received message correlation {}", correlation.getPayload());
            this.messageService.correlateMessage(this.messageApiMapper.map((CorrelateMessageTOV01)correlation.getPayload()));
        };
    }

    public MessageEventListener(MessageService messageService, MessageApiMapper messageApiMapper) {
        this.messageService = messageService;
        this.messageApiMapper = messageApiMapper;
    }
}

