/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.message.domain.service;

import io.muenchendigital.digiwf.engine.mapper.EngineDataMapper;
import io.muenchendigital.digiwf.message.domain.model.CorrelateMessage;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.runtime.MessageCorrelationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class MessageService {
    private static final Logger log = LoggerFactory.getLogger(MessageService.class);
    private final RuntimeService runtimeService;
    private final EngineDataMapper engineDataMapper;

    public void correlateMessage(CorrelateMessage correlateMessage) {
        Map variables;
        log.debug("correlateMessage {}", (Object)correlateMessage);
        MessageCorrelationBuilder builder = this.runtimeService.createMessageCorrelation(correlateMessage.getMessageName());
        if (correlateMessage.getPayloadVariables() != null && !correlateMessage.getPayloadVariables().isEmpty()) {
            variables = this.engineDataMapper.mapObjectsToVariables(correlateMessage.getPayloadVariables());
            builder.setVariables(variables);
        }
        if (correlateMessage.getPayloadVariablesLocal() != null && !correlateMessage.getPayloadVariablesLocal().isEmpty()) {
            variables = this.engineDataMapper.mapObjectsToVariables(correlateMessage.getPayloadVariablesLocal());
            builder.setVariablesLocal(variables);
        }
        if (StringUtils.isNotBlank((CharSequence)correlateMessage.getProcessInstanceId())) {
            builder.processInstanceId(correlateMessage.getProcessInstanceId());
        }
        if (StringUtils.isNotBlank((CharSequence)correlateMessage.getBusinessKey())) {
            builder.processInstanceBusinessKey(correlateMessage.getBusinessKey());
        }
        builder.correlate();
    }

    public void sendMessage(String instanceId, String message, String userId, List<String> groups) {
        log.debug("sendMessage {} to instance {}", (Object)message, (Object)instanceId);
        this.runtimeService.createMessageCorrelation(message).processInstanceId(instanceId).correlate();
    }

    public MessageService(RuntimeService runtimeService, EngineDataMapper engineDataMapper) {
        this.runtimeService = runtimeService;
        this.engineDataMapper = engineDataMapper;
    }
}

