/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.output.process;

import io.holunda.camunda.bpm.data.CamundaBpmData;
import io.holunda.camunda.bpm.data.factory.VariableFactory;
import io.muenchendigital.digiwf.engine.mapper.EngineDataMapper;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;

public class AbstractStreamingIntegrationDelegate {
    private final EngineDataMapper engineDataMapper;
    private static final VariableFactory<String> MESSAGE_NAME = CamundaBpmData.stringVariable((String)"app_message_name");
    private static final VariableFactory<String> TYPE_NAME = CamundaBpmData.stringVariable((String)"app_type_name");
    private static final VariableFactory<String> TOPIC_NAME = CamundaBpmData.stringVariable((String)"app_topic_name");
    private static final VariableFactory<String> RESPONSELESS = CamundaBpmData.stringVariable((String)"app_responseless");
    private static final List<String> filterVariables = List.of(MESSAGE_NAME.getName(), TYPE_NAME.getName(), TOPIC_NAME.getName(), RESPONSELESS.getName());

    public AbstractStreamingIntegrationDelegate(EngineDataMapper engineDataMapper) {
        this.engineDataMapper = engineDataMapper;
    }

    protected Message<Map<String, Object>> mapMessage(DelegateExecution delegateExecution, Map<String, Object> variables) {
        Map data = this.filterVariables(variables);
        MessageBuilder builder = MessageBuilder.withPayload((Object)this.engineDataMapper.mapToData(data)).setHeader("spring.cloud.stream.sendto.destination", TOPIC_NAME.from((VariableScope)delegateExecution).get()).setHeader("type", TYPE_NAME.from((VariableScope)delegateExecution).get()).setHeader("digiwf.processinstanceid", (Object)delegateExecution.getProcessInstanceId());
        MESSAGE_NAME.from((VariableScope)delegateExecution).getOptional().ifPresent(name -> builder.setHeader("digiwf.messagename", name));
        return builder.build();
    }

    private Map<String, Object> filterVariables(Map<String, Object> variables) {
        return variables.entrySet().stream().filter(entry -> !filterVariables.contains(entry.getKey())).filter(entry -> entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

