/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.output.process;

import io.muenchendigital.digiwf.engine.mapper.EngineDataMapper;
import io.muenchendigital.digiwf.output.process.AbstractStreamingIntegrationDelegate;
import java.util.Map;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Sinks;

@Component
public class StreamingTemplateIntegrationDelegate
extends AbstractStreamingIntegrationDelegate
implements JavaDelegate {
    private static final Logger log = LoggerFactory.getLogger(StreamingTemplateIntegrationDelegate.class);
    private final Sinks.Many<Message<Map<String, Object>>> dynamicSink;

    public StreamingTemplateIntegrationDelegate(EngineDataMapper engineDataMapper, Sinks.Many<Message<Map<String, Object>>> dynamicSink) {
        super(engineDataMapper);
        this.dynamicSink = dynamicSink;
    }

    public void execute(DelegateExecution delegateExecution) throws Exception {
        Map localVariables = delegateExecution.getVariables();
        log.debug("Send event to stream {}", (Object)localVariables);
        Message message = this.mapMessage(delegateExecution, localVariables);
        this.dynamicSink.tryEmitNext((Object)message).orThrow();
    }
}

