/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.process.definition.api.resource;

import io.muenchendigital.digiwf.process.definition.domain.service.ServiceStartFileService;
import io.muenchendigital.digiwf.shared.file.presignedUrlAdapters.PresignedUrlAction;
import io.muenchendigital.digiwf.shared.security.AppAuthenticationProvider;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Transactional
@RequestMapping(value={"/rest/service/start/file"})
@Tag(name="ServiceStartFileRestController", description="API to perform actions on service start files")
public class ServiceStartFileRestController {
    private final ServiceStartFileService serviceStartFileService;
    private final AppAuthenticationProvider authenticationProvider;

    @GetMapping(value={"/{definitionKey}"})
    public ResponseEntity<List<String>> getFileNames(@PathVariable String definitionKey, @RequestParam String filePath) {
        List fileNames = this.serviceStartFileService.getFileNames(definitionKey, filePath, this.authenticationProvider.getCurrentUserId(), this.authenticationProvider.getCurrentUserGroups());
        return ResponseEntity.ok((Object)fileNames);
    }

    @GetMapping(value={"/{definitionKey}/{fileName}"})
    public ResponseEntity<String> getPresignedUrlForFileDownload(@PathVariable String definitionKey, @PathVariable String fileName, @RequestParam String filePath) {
        String presignedUrl = this.serviceStartFileService.getPresignedUrl(PresignedUrlAction.GET, definitionKey, filePath, fileName, this.authenticationProvider.getCurrentUserId(), this.authenticationProvider.getCurrentUserGroups());
        return ResponseEntity.ok((Object)presignedUrl);
    }

    @PostMapping(value={"/{definitionKey}/{filename}"})
    public ResponseEntity<String> getPresignedUrlForFileUpload(@PathVariable String definitionKey, @PathVariable String filename, @RequestParam String filePath) {
        String presignedUrls = this.serviceStartFileService.getPresignedUrl(PresignedUrlAction.POST, definitionKey, filePath, filename, this.authenticationProvider.getCurrentUserId(), this.authenticationProvider.getCurrentUserGroups());
        return ResponseEntity.ok((Object)presignedUrls);
    }

    @DeleteMapping(value={"/{definitionKey}/{filename}"})
    public ResponseEntity<String> getPresignedUrlForFileDeletion(@PathVariable String definitionKey, @PathVariable String filename, @RequestParam String filePath) {
        String presignedUrl = this.serviceStartFileService.getPresignedUrl(PresignedUrlAction.DELETE, definitionKey, filePath, filename, this.authenticationProvider.getCurrentUserId(), this.authenticationProvider.getCurrentUserGroups());
        return ResponseEntity.ok((Object)presignedUrl);
    }

    public ServiceStartFileRestController(ServiceStartFileService serviceStartFileService, AppAuthenticationProvider authenticationProvider) {
        this.serviceStartFileService = serviceStartFileService;
        this.authenticationProvider = authenticationProvider;
    }
}

