/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.process.definition.domain.model;

import io.muenchendigital.digiwf.process.definition.domain.model.StartContext;
import java.util.Optional;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Table;
import org.hibernate.annotations.GenericGenerator;

@Entity(name="StartContext")
@Table(name="DWF_START_CONTEXT", indexes={@Index(name="IDX_DWF_CONTEXT_USER", columnList="userid_, definitionkey_")})
public class StartContext {
    @Id
    @GeneratedValue(generator="uuid2")
    @GenericGenerator(name="uuid2", strategy="uuid2")
    @Column(name="id_", unique=true, nullable=false, length=36)
    private String id;
    @Column(name="userid_", nullable=false)
    private String userId;
    @Column(name="definitionkey_", nullable=false)
    private String definitionKey;
    @Column(name="filecontext_", nullable=false)
    private String fileContext;

    public StartContext(String userId, String definitionKey) {
        this(userId, definitionKey, null);
    }

    public StartContext(String userId, String definitionKey, String fileContext) {
        this.userId = userId;
        this.definitionKey = definitionKey;
        this.fileContext = Optional.ofNullable(fileContext).orElse(UUID.randomUUID().toString());
    }

    public static StartContextBuilder builder() {
        return new StartContextBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getDefinitionKey() {
        return this.definitionKey;
    }

    public String getFileContext() {
        return this.fileContext;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setDefinitionKey(String definitionKey) {
        this.definitionKey = definitionKey;
    }

    public void setFileContext(String fileContext) {
        this.fileContext = fileContext;
    }

    public String toString() {
        return "StartContext(id=" + this.getId() + ", userId=" + this.getUserId() + ", definitionKey=" + this.getDefinitionKey() + ", fileContext=" + this.getFileContext() + ")";
    }

    public StartContext() {
    }

    public StartContext(String id, String userId, String definitionKey, String fileContext) {
        this.id = id;
        this.userId = userId;
        this.definitionKey = definitionKey;
        this.fileContext = fileContext;
    }
}

