/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.process.definition.domain.service;

import io.muenchendigital.digiwf.engine.mapper.EngineDataMapper;
import io.muenchendigital.digiwf.json.serialization.JsonSerializationService;
import io.muenchendigital.digiwf.json.validation.JsonSchemaValidator;
import io.muenchendigital.digiwf.legacy.form.domain.service.FormService;
import io.muenchendigital.digiwf.legacy.shared.data.DataService;
import io.muenchendigital.digiwf.process.config.domain.model.ProcessConfig;
import io.muenchendigital.digiwf.process.config.domain.service.ProcessConfigService;
import io.muenchendigital.digiwf.process.definition.domain.model.ServiceDefinitionDetail;
import io.muenchendigital.digiwf.shared.exception.VariablesNotValidException;
import java.util.Map;
import java.util.Optional;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ServiceDefinitionDataService {
    private static final Logger log = LoggerFactory.getLogger(ServiceDefinitionDataService.class);
    private final ProcessConfigService processConfigService;
    private final EngineDataMapper engineDataMapper;
    private final JsonSchemaValidator validationService;
    private final JsonSerializationService serializationService;
    private final DataService dataService;
    private final FormService formService;

    public Map<String, Object> serializeVariables(ServiceDefinitionDetail definition, Map<String, Object> variables) {
        Map serializedVariables;
        if (Optional.ofNullable(definition.getStartForm()).isPresent()) {
            boolean ignoreFields = this.processConfigService.getProcessConfig(definition.getKey()).map(ProcessConfig::isIgnoreFieldsOnStart).orElse(false);
            if (!ignoreFields && !this.formService.validateVariables(definition.getStartForm().getKey(), variables)) {
                throw new VariablesNotValidException("Not allowed");
            }
            Map filteredVariables = this.dataService.filterReadonly(definition.getStartForm(), variables);
            serializedVariables = this.dataService.serializeVariables(definition.getStartForm(), filteredVariables);
        } else if (Optional.ofNullable(definition.getJsonSchema()).isPresent()) {
            serializedVariables = this.initalizeData(definition, variables);
        } else {
            throw new IllegalArgumentException();
        }
        return serializedVariables;
    }

    private Map<String, Object> initalizeData(ServiceDefinitionDetail definition, Map<String, Object> variables) {
        JSONObject filteredData = this.serializationService.filter(definition.getJsonSchema(), variables, true);
        this.validationService.validate(definition.getJsonSchema(), filteredData.toMap());
        JSONObject previousData = this.serializationService.initialize(new JSONObject(definition.getJsonSchema()).toString());
        Map clearedData = this.serializationService.merge(filteredData, previousData);
        JSONObject defaultValue = this.serializationService.initialize(new JSONObject(definition.getJsonSchema()).toString());
        Map serializedData = this.serializationService.merge(new JSONObject(clearedData), defaultValue);
        return this.engineDataMapper.mapObjectsToVariables(serializedData);
    }

    public ServiceDefinitionDataService(ProcessConfigService processConfigService, EngineDataMapper engineDataMapper, JsonSchemaValidator validationService, JsonSerializationService serializationService, DataService dataService, FormService formService) {
        this.processConfigService = processConfigService;
        this.engineDataMapper = engineDataMapper;
        this.validationService = validationService;
        this.serializationService = serializationService;
        this.dataService = dataService;
        this.formService = formService;
    }
}

