/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.process.definition.domain.service;

import io.muenchendigital.digiwf.process.definition.domain.mapper.ServiceDefinitionMapper;
import io.muenchendigital.digiwf.process.definition.domain.model.ServiceDefinition;
import io.muenchendigital.digiwf.process.definition.domain.model.ServiceDefinitionDetail;
import io.muenchendigital.digiwf.process.definition.domain.model.StartContext;
import io.muenchendigital.digiwf.process.instance.domain.model.ServiceInstance;
import io.muenchendigital.digiwf.process.instance.domain.service.ServiceInstanceService;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.variable.Variables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ServiceDefinitionService {
    private static final Logger log = LoggerFactory.getLogger(ServiceDefinitionService.class);
    private final RepositoryService repositoryService;
    private final RuntimeService runtimeService;
    private final ServiceDefinitionMapper serviceDefinitionMapper;
    private final ServiceInstanceService serviceInstanceService;

    public void startInstance(ServiceDefinitionDetail detail, String businessKey, Map<String, Object> variables, String userId, StartContext startContext) {
        log.debug("Start Process: " + detail.getKey());
        ServiceInstance serviceInstance = this.serviceInstanceService.creatServiceInstance(detail.getName(), detail.getKey());
        variables.put("starterOfInstance", userId);
        variables.put("app_process_status", "Gestartet");
        variables.put("app_file_context", startContext.getFileContext());
        variables.put("app_process_info_id", Variables.stringValue((String)serviceInstance.getId(), (boolean)true));
        ProcessInstance processInstance = StringUtils.isEmpty((CharSequence)businessKey) ? this.runtimeService.startProcessInstanceByKey(detail.getKey(), variables) : this.runtimeService.startProcessInstanceByKey(detail.getKey(), businessKey, variables);
        this.serviceInstanceService.authorizeServiceInstance(processInstance.getId(), userId);
        this.serviceInstanceService.updateInstanceId(serviceInstance.getId(), processInstance.getId());
        log.info("process instance for key {} started: {}", (Object)detail.getKey(), (Object)processInstance.getId());
    }

    public ProcessDefinition getServiceDefinition(String id) {
        ProcessDefinition serviceDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(id).singleResult();
        if (serviceDefinition == null) {
            throw new IllegalArgumentException(String.format("The servicedefinition with the id %s is not available.", id));
        }
        return serviceDefinition;
    }

    public List<ServiceDefinition> getServiceDefinitions() {
        List serviceDefinitions = this.repositoryService.createProcessDefinitionQuery().latestVersion().list();
        return this.serviceDefinitionMapper.map(serviceDefinitions);
    }

    public ServiceDefinitionDetail getServiceDefinitionDetail(String key, String userId, List<String> groups) {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().latestVersion().processDefinitionKey(key).singleResult();
        return this.serviceDefinitionMapper.map(processDefinition);
    }

    public ServiceDefinitionService(RepositoryService repositoryService, RuntimeService runtimeService, ServiceDefinitionMapper serviceDefinitionMapper, ServiceInstanceService serviceInstanceService) {
        this.repositoryService = repositoryService;
        this.runtimeService = runtimeService;
        this.serviceDefinitionMapper = serviceDefinitionMapper;
        this.serviceInstanceService = serviceInstanceService;
    }
}

