/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.process.definition.domain.service;

import io.muenchendigital.digiwf.process.definition.domain.model.StartContext;
import io.muenchendigital.digiwf.process.definition.infrastructure.StartContextRepository;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ServiceStartContextService {
    private static final Logger log = LoggerFactory.getLogger(ServiceStartContextService.class);
    private final StartContextRepository startContextRepository;

    public Optional<StartContext> getStartContext(String userId, String definitionKey) {
        return this.startContextRepository.findByUserIdAndDefinitionKey(userId, definitionKey);
    }

    public StartContext createStartContext(String userId, String definitionKey) {
        StartContext newContext = new StartContext(userId, definitionKey);
        return (StartContext)this.startContextRepository.save((Object)newContext);
    }

    public void deleteStartContext(String userId, String definitionKey) {
        this.getStartContext(userId, definitionKey).ifPresent(arg_0 -> ((StartContextRepository)this.startContextRepository).delete(arg_0));
    }

    public ServiceStartContextService(StartContextRepository startContextRepository) {
        this.startContextRepository = startContextRepository;
    }
}

