/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.process.definition.domain.service;

import io.muenchendigital.digiwf.process.config.domain.model.ProcessConfig;
import io.muenchendigital.digiwf.process.config.domain.service.ProcessConfigService;
import io.muenchendigital.digiwf.process.config.process.ProcessConfigFunctions;
import io.muenchendigital.digiwf.process.definition.domain.model.StartContext;
import io.muenchendigital.digiwf.process.definition.domain.service.ServiceStartContextService;
import io.muenchendigital.digiwf.s3.integration.client.repository.DocumentStorageFolderRepository;
import io.muenchendigital.digiwf.shared.exception.IllegalResourceAccessException;
import io.muenchendigital.digiwf.shared.exception.NoFileContextException;
import io.muenchendigital.digiwf.shared.file.AbstractFileService;
import io.muenchendigital.digiwf.shared.file.presignedUrlAdapters.PresignedUrlAction;
import io.muenchendigital.digiwf.shared.file.presignedUrlAdapters.PresignedUrlAdapter;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ServiceStartFileService
extends AbstractFileService {
    private static final Logger log = LoggerFactory.getLogger(ServiceStartFileService.class);
    private final ServiceStartContextService serviceStartContextService;
    private final ProcessConfigService processConfigService;

    public ServiceStartFileService(DocumentStorageFolderRepository documentStorageFolderRepository, ServiceStartContextService serviceStartContextService, ProcessConfigService processConfigService, List<PresignedUrlAdapter> presignedUrlAdapters, ProcessConfigFunctions processConfigFunctions) {
        super(documentStorageFolderRepository, presignedUrlAdapters, processConfigFunctions);
        this.serviceStartContextService = serviceStartContextService;
        this.processConfigService = processConfigService;
    }

    public List<String> getFileNames(String definitionKey, String filePath, String userId, List<String> groups) {
        this.checkReadAccess(definitionKey, filePath);
        String fileContext = this.getFileContext(userId, definitionKey);
        return super.getFileNames(filePath, fileContext, this.getDocumentStorageUrl(definitionKey));
    }

    public String getPresignedUrl(PresignedUrlAction action, String definitionKey, String filePath, String fileName, String userId, List<String> groups) {
        if (action.equals((Object)PresignedUrlAction.GET)) {
            this.checkReadAccess(definitionKey, filePath);
        } else {
            this.checkWriteAccess(definitionKey, filePath);
        }
        String fileContext = this.getFileContext(userId, definitionKey);
        return super.getPresignedUrl(action, fileContext + "/" + filePath + "/" + fileName, this.getDocumentStorageUrl(definitionKey));
    }

    private String getFileContext(String userId, String definitionKey) {
        return this.serviceStartContextService.getStartContext(userId, definitionKey).map(StartContext::getFileContext).orElseThrow(() -> new NoFileContextException("No file context found for task"));
    }

    private void checkReadAccess(String identifier, String filePath) {
        try {
            this.checkWriteAccess(identifier, filePath);
        }
        catch (IllegalResourceAccessException ex) {
            String filePathsReadonly = this.processConfigService.getProcessConfig(identifier).map(ProcessConfig::getFilePathsReadonly).orElse(null);
            if (StringUtils.isEmpty((CharSequence)filePathsReadonly)) {
                throw new IllegalResourceAccessException("No access to defined property");
            }
            Arrays.stream(filePathsReadonly.split(";")).filter(filePath::startsWith).findFirst().orElseThrow(() -> new IllegalResourceAccessException("No access to defined property"));
        }
    }

    private void checkWriteAccess(String identifier, String filePath) {
        String filePaths = this.processConfigService.getProcessConfig(identifier).map(ProcessConfig::getFilePaths).orElse(null);
        if (StringUtils.isEmpty((CharSequence)filePaths)) {
            throw new IllegalResourceAccessException("No access to defined property");
        }
        Arrays.stream(filePaths.split(";")).filter(filePath::startsWith).findFirst().orElseThrow(() -> new IllegalResourceAccessException("No access to defined property"));
    }
}

