/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.process.instance.api.resource;

import io.muenchendigital.digiwf.process.instance.api.mapper.ServiceInstanceApiMapper;
import io.muenchendigital.digiwf.process.instance.api.transport.ServiceInstanceDetailTO;
import io.muenchendigital.digiwf.process.instance.api.transport.ServiceInstanceTO;
import io.muenchendigital.digiwf.process.instance.domain.model.ServiceInstanceDetail;
import io.muenchendigital.digiwf.process.instance.domain.service.ServiceInstanceService;
import io.muenchendigital.digiwf.shared.security.AppAuthenticationProvider;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Transactional
@RequestMapping(value={"/rest/service/instance"})
@Tag(name="ServiceInstanceController", description="API to interact with service instances")
public class ServiceInstanceController {
    private final ServiceInstanceService processInstanceService;
    private final AppAuthenticationProvider authenticationProvider;
    private final ServiceInstanceApiMapper serviceInstanceApiMapper;

    @GetMapping
    public ResponseEntity<List<ServiceInstanceTO>> getAssignedInstances() {
        List startedInstances = this.processInstanceService.getProcessInstanceByUser(this.authenticationProvider.getCurrentUserId());
        return ResponseEntity.ok((Object)this.serviceInstanceApiMapper.map2TO(startedInstances));
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<ServiceInstanceDetailTO> getProcessInstanceDetail(@PathVariable(value="id") String id) {
        ServiceInstanceDetail startedInstances = this.processInstanceService.getServiceInstanceDetail(id);
        return ResponseEntity.ok((Object)this.serviceInstanceApiMapper.map2TO(startedInstances));
    }

    public ServiceInstanceController(ServiceInstanceService processInstanceService, AppAuthenticationProvider authenticationProvider, ServiceInstanceApiMapper serviceInstanceApiMapper) {
        this.processInstanceService = processInstanceService;
        this.authenticationProvider = authenticationProvider;
        this.serviceInstanceApiMapper = serviceInstanceApiMapper;
    }
}

