/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.process.instance.api.resource;

import io.muenchendigital.digiwf.process.instance.domain.service.ServiceInstanceFileService;
import io.muenchendigital.digiwf.shared.file.presignedUrlAdapters.PresignedUrlAction;
import io.muenchendigital.digiwf.shared.security.AppAuthenticationProvider;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Transactional
@RequestMapping(value={"/rest/service/instance/file"})
@Tag(name="ServiceInstanceFileRestController", description="API to perform actions on service instance files")
public class ServiceInstanceFileRestController {
    private final ServiceInstanceFileService serviceInstanceFileService;
    private final AppAuthenticationProvider authenticationProvider;

    @GetMapping(value={"/{instanceId}"})
    public ResponseEntity<List<String>> getFileNames(@PathVariable String instanceId, @RequestParam String filePath) {
        List fileNames = this.serviceInstanceFileService.getFileNames(instanceId, filePath, this.authenticationProvider.getCurrentUserId());
        return ResponseEntity.ok((Object)fileNames);
    }

    @GetMapping(value={"/{instanceId}/{fileName}"})
    public ResponseEntity<String> getPresignedUrlForFileDownload(@PathVariable String instanceId, @PathVariable String fileName, @RequestParam String filePath) {
        String presignedUrl = this.serviceInstanceFileService.getPresignedUrl(PresignedUrlAction.GET, instanceId, filePath, fileName, this.authenticationProvider.getCurrentUserId());
        return ResponseEntity.ok((Object)presignedUrl);
    }

    @PostMapping(value={"/{instanceId}/{filename}"})
    public ResponseEntity<String> getPresignedUrlForFileUpload(@PathVariable String instanceId, @PathVariable String filename, @RequestParam String filePath) {
        String presignedUrls = this.serviceInstanceFileService.getPresignedUrl(PresignedUrlAction.POST, instanceId, filePath, filename, this.authenticationProvider.getCurrentUserId());
        return ResponseEntity.ok((Object)presignedUrls);
    }

    @DeleteMapping(value={"/{instanceId}/{filename}"})
    public ResponseEntity<String> getPresignedUrlForFileDeletion(@PathVariable String instanceId, @PathVariable String filename, @RequestParam String filePath) {
        String presignedUrl = this.serviceInstanceFileService.getPresignedUrl(PresignedUrlAction.DELETE, instanceId, filePath, filename, this.authenticationProvider.getCurrentUserId());
        return ResponseEntity.ok((Object)presignedUrl);
    }

    public ServiceInstanceFileRestController(ServiceInstanceFileService serviceInstanceFileService, AppAuthenticationProvider authenticationProvider) {
        this.serviceInstanceFileService = serviceInstanceFileService;
        this.authenticationProvider = authenticationProvider;
    }
}

