/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.shared.file;

import io.muenchendigital.digiwf.process.config.process.ProcessConfigFunctions;
import io.muenchendigital.digiwf.s3.integration.client.repository.DocumentStorageFolderRepository;
import io.muenchendigital.digiwf.shared.file.presignedUrlAdapters.PresignedUrlAction;
import io.muenchendigital.digiwf.shared.file.presignedUrlAdapters.PresignedUrlAdapter;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.client.HttpServerErrorException;

public abstract class AbstractFileService {
    private static final Logger log = LoggerFactory.getLogger(AbstractFileService.class);
    public static final String FILEPATH_DELIMITER = ";";
    public static final String ERRTEXT_ILLEGAL_ACCESS = "No access to defined property";
    protected final DocumentStorageFolderRepository documentStorageFolderRepository;
    private final List<PresignedUrlAdapter> presignedUrlAdapters;
    private final ProcessConfigFunctions processConfigFunctions;

    public AbstractFileService(DocumentStorageFolderRepository documentStorageFolderRepository, List<PresignedUrlAdapter> presignedUrlAdapters, ProcessConfigFunctions processConfigFunctions) {
        this.documentStorageFolderRepository = documentStorageFolderRepository;
        this.presignedUrlAdapters = presignedUrlAdapters;
        this.processConfigFunctions = processConfigFunctions;
    }

    public List<String> getFileNames(String filePath, String fileContext, Optional<String> documentStorageUrl) {
        try {
            if (documentStorageUrl.isPresent()) {
                return this.removeFolderFromPaths((Set)this.documentStorageFolderRepository.getAllFilesInFolderRecursively(fileContext + "/" + filePath, documentStorageUrl.get()).block());
            }
            return this.removeFolderFromPaths((Set)this.documentStorageFolderRepository.getAllFilesInFolderRecursively(fileContext + "/" + filePath).block());
        }
        catch (Exception ex) {
            log.error("Getting all files of folder {} failed: {}", (Object)filePath, (Object)ex);
            throw new HttpServerErrorException(HttpStatus.INTERNAL_SERVER_ERROR, String.format("Getting all files of folder %s failed", filePath));
        }
    }

    protected String getPresignedUrl(PresignedUrlAction action, String pathToFile, Optional<String> documentStorageUrl) {
        Optional<PresignedUrlAdapter> handler = this.presignedUrlAdapters.stream().filter(h -> h.isResponsibleForAction(action)).findAny();
        if (handler.isPresent()) {
            if (documentStorageUrl.isPresent()) {
                return handler.get().getPresignedUrl(documentStorageUrl.get(), pathToFile, 5);
            }
            return handler.get().getPresignedUrl(pathToFile, 5);
        }
        log.warn("No handler specified for action {}", (Object)action);
        throw new RuntimeException(String.format("No handler specified for action %s", action));
    }

    protected Optional<String> getDocumentStorageUrl(String definitionKey) {
        return this.processConfigFunctions.get("app_file_s3_sync_config", definitionKey);
    }

    private List<String> removeFolderFromPaths(Set<String> fileList) {
        return fileList.stream().map(file -> file.substring(file.lastIndexOf("/") + 1)).collect(Collectors.toList());
    }
}

