/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.shared.gracefulshutdown;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.stereotype.Component;

@Component
public class GracefulShutdownHealthCheck
implements HealthIndicator {
    private static final Logger LOG = LoggerFactory.getLogger(GracefulShutdownHealthCheck.class);
    public static final String GRACEFULSHUTDOWN = "Gracefulshutdown";
    public static final String APPLICATION_UP_MESSAGE = "application up";
    public static final String APPLICATION_DOWN_MESSAGE = "gracefully shutting down";
    private Health health;

    GracefulShutdownHealthCheck() {
        this.setStatusUp();
    }

    public Health health() {
        return this.health;
    }

    public void setStatusUp() {
        this.health = new Health.Builder().withDetail(GRACEFULSHUTDOWN, (Object)APPLICATION_UP_MESSAGE).up().build();
        LOG.info("Gracefulshutdown healthcheck UP");
    }

    public void setStatusDown() {
        this.health = new Health.Builder().withDetail(GRACEFULSHUTDOWN, (Object)APPLICATION_DOWN_MESSAGE).down().build();
        LOG.info("Gracefulshutdown healthcheck DOWN");
    }

    public String toString() {
        return "GracefulShutdownHealthCheck(health=" + this.health + ")";
    }
}

