/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.cleanup.delegates;

import io.holunda.camunda.bpm.data.CamundaBpmData;
import io.holunda.camunda.bpm.data.factory.VariableFactory;
import io.muenchendigital.digiwf.cleanup.services.RemovaltimeUpdateService;
import java.util.List;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class UpdateRemovaltimeDelegate
implements JavaDelegate {
    private static final Logger log = LoggerFactory.getLogger(UpdateRemovaltimeDelegate.class);
    private final RemovaltimeUpdateService removaltimeUpdateService;
    public static final VariableFactory<List<String>> ASSEMBLED_UPDATE_REMOVALTIME_BATCH = CamundaBpmData.listVariable((String)"assembled_update_removaltime_batch", String.class);
    public static final VariableFactory<Integer> UPDATED_PROCESS_INSTANCES = CamundaBpmData.intVariable((String)"updated_process_instances");

    public void execute(DelegateExecution delegateExecution) throws Exception {
        log.debug("Updating Removaltime");
        List instanceIds = (List)ASSEMBLED_UPDATE_REMOVALTIME_BATCH.from((VariableScope)delegateExecution).get();
        for (String instanceId : instanceIds) {
            if (!this.removaltimeUpdateService.updateServiceInstance(instanceId)) continue;
            this.incrementCounter(delegateExecution);
        }
    }

    private void incrementCounter(DelegateExecution delegateExecution) {
        Integer counter = (Integer)UPDATED_PROCESS_INSTANCES.from((VariableScope)delegateExecution).get();
        counter = counter + 1;
        UPDATED_PROCESS_INSTANCES.on((VariableScope)delegateExecution).set((Object)counter);
        log.debug("Update counter: {}", (Object)counter);
    }

    public UpdateRemovaltimeDelegate(RemovaltimeUpdateService removaltimeUpdateService) {
        this.removaltimeUpdateService = removaltimeUpdateService;
    }
}

