/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.cleanup.delegates;

import io.holunda.camunda.bpm.data.CamundaBpmData;
import io.holunda.camunda.bpm.data.factory.VariableFactory;
import io.muenchendigital.digiwf.cleanup.services.TimeToLiveUpdateService;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class UpdateTimeToLiveDelegate
implements JavaDelegate {
    private static final Logger log = LoggerFactory.getLogger(UpdateTimeToLiveDelegate.class);
    private final TimeToLiveUpdateService cleanupService;
    public static final VariableFactory<Integer> TIME_TO_LIVE = CamundaBpmData.intVariable((String)"digiwf_time_to_live");

    public void execute(DelegateExecution delegateExecution) throws Exception {
        log.info("Updating TTL");
        Integer timeToLive = (Integer)TIME_TO_LIVE.from((VariableScope)delegateExecution).getLocal();
        this.cleanupService.updateResourcesHistoryTimeToLive(timeToLive);
    }

    public UpdateTimeToLiveDelegate(TimeToLiveUpdateService cleanupService) {
        this.cleanupService = cleanupService;
    }
}

