/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.cleanup.services.calculation;

import io.muenchendigital.digiwf.cleanup.services.calculation.CleanupCalculationStrategy;
import java.util.Date;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class CleanupCalculator {
    @Value(value="${camunda.bpm.generic-properties.properties.history-time-to-live:185}")
    private Integer historyTimeToLive;
    private final RepositoryService repositoryService;
    private final CleanupCalculationStrategy cleanupCalculationStrategy;

    public Date calculateRemovalTime(String processDefinitionKey, Date startTime, Date endTime) {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processDefinitionKey).latestVersion().singleResult();
        Integer ttl = processDefinition.getHistoryTimeToLive() != null ? processDefinition.getHistoryTimeToLive() : this.historyTimeToLive;
        return this.cleanupCalculationStrategy.calculateRemovalTime(ttl, startTime, endTime);
    }

    public boolean canCalculate(Date startTime, Date endTime) {
        return this.cleanupCalculationStrategy.canCalculate(startTime, endTime);
    }

    public CleanupCalculator(RepositoryService repositoryService, CleanupCalculationStrategy cleanupCalculationStrategy) {
        this.repositoryService = repositoryService;
        this.cleanupCalculationStrategy = cleanupCalculationStrategy;
    }
}

