/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.cleanup.services.calculation;

import io.muenchendigital.digiwf.cleanup.services.calculation.CleanupCalculationStrategy;
import java.util.Date;
import java.util.GregorianCalendar;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="camunda.bpm.generic-properties.properties", name={"history-removal-time-strategy"}, havingValue="end")
public class EndTimeCleanupCalculationStrategy
implements CleanupCalculationStrategy {
    public Date calculateRemovalTime(Integer ttl, Date startTime, Date endTime) {
        if (endTime == null) {
            return null;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(endTime);
        cal.add(6, ttl);
        return cal.getTime();
    }

    public boolean canCalculate(Date startTime, Date endTime) {
        return endTime != null;
    }
}

