/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.deployment.api.streaming;

import io.muenchendigital.digiwf.asyncapi.docs.annotations.DocumentAsyncAPI;
import io.muenchendigital.digiwf.deployment.api.mapper.DeploymentMapper;
import io.muenchendigital.digiwf.deployment.api.streaming.event.DeploymentEvent;
import io.muenchendigital.digiwf.deployment.domain.model.DeploymentStatusModel;
import io.muenchendigital.digiwf.deployment.domain.service.ModelDeploymentService;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Sinks;

@Component
public class DeploymentEventListener {
    private static final Logger log = LoggerFactory.getLogger(DeploymentEventListener.class);
    private final Sinks.Many<Message<DeploymentStatusModel>> statusEmitter;
    private final ModelDeploymentService modelDeploymentService;
    private final DeploymentMapper mapper;

    @DocumentAsyncAPI(payload=DeploymentEvent.class, functionRouter=true, typeHeader="deploy")
    @Bean
    public Consumer<Message<DeploymentEvent>> deploy() {
        return message -> {
            DeploymentEvent deploymentEvent = (DeploymentEvent)message.getPayload();
            log.info("Sent deployment event with deploymentId: {}, versionId: {}, target: {}, artifactType: {}", new Object[]{deploymentEvent.getDeploymentId(), deploymentEvent.getVersionId(), deploymentEvent.getTarget(), deploymentEvent.getArtifactType()});
            DeploymentStatusModel status = this.modelDeploymentService.deploy(this.mapper.mapToDeploymentModel(deploymentEvent));
            Message statusMessage = MessageBuilder.withPayload((Object)status).build();
            this.statusEmitter.tryEmitNext((Object)statusMessage).orThrow();
            log.debug("Sent deployment status event for deployment {}", (Object)status.getDeploymentId());
        };
    }

    public DeploymentEventListener(Sinks.Many<Message<DeploymentStatusModel>> statusEmitter, ModelDeploymentService modelDeploymentService, DeploymentMapper mapper) {
        this.statusEmitter = statusEmitter;
        this.modelDeploymentService = modelDeploymentService;
        this.mapper = mapper;
    }
}

