/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.filters.api.resource;

import io.muenchendigital.digiwf.filters.api.mapper.FilterApiMapper;
import io.muenchendigital.digiwf.filters.api.transport.FilterTO;
import io.muenchendigital.digiwf.filters.api.transport.SaveFilterTO;
import io.muenchendigital.digiwf.filters.domain.service.PersistentFilterService;
import io.muenchendigital.digiwf.shared.security.AppAuthenticationProvider;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Transactional
@RequestMapping(value={"/rest/filter"})
@Tag(name="FilterRestController", description="API to load user filters and perform actions on them")
public class FiltersRestController {
    private static final Logger log = LoggerFactory.getLogger(FiltersRestController.class);
    private final PersistentFilterService persistentFilterService;
    private final AppAuthenticationProvider authenticationProvider;
    private final FilterApiMapper filterApiMapper;

    @GetMapping
    public ResponseEntity<List<FilterTO>> getFilters() {
        log.debug("getFilters");
        List filters = this.persistentFilterService.getFilters(this.authenticationProvider.getCurrentUserId());
        return ResponseEntity.ok((Object)this.filterApiMapper.map2TO(filters));
    }

    @PutMapping
    public ResponseEntity<FilterTO> saveFilter(@Valid @RequestBody SaveFilterTO filterTO) {
        this.persistentFilterService.saveFilter(this.filterApiMapper.map(filterTO, this.authenticationProvider.getCurrentUserId()));
        return ResponseEntity.ok().build();
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> delete(@PathVariable(value="id") String filterId) {
        this.persistentFilterService.deleteFilter(filterId, this.authenticationProvider.getCurrentUserId());
        return ResponseEntity.ok().build();
    }

    public FiltersRestController(PersistentFilterService persistentFilterService, AppAuthenticationProvider authenticationProvider, FilterApiMapper filterApiMapper) {
        this.persistentFilterService = persistentFilterService;
        this.authenticationProvider = authenticationProvider;
        this.filterApiMapper = filterApiMapper;
    }
}

