/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.filters.domain.service;

import io.muenchendigital.digiwf.filters.domain.mapper.FilterMapper;
import io.muenchendigital.digiwf.filters.domain.model.Filter;
import io.muenchendigital.digiwf.filters.infrastructure.repository.FilterRepository;
import io.muenchendigital.digiwf.shared.exception.IllegalResourceAccessException;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PersistentFilterService {
    private static final Logger log = LoggerFactory.getLogger(PersistentFilterService.class);
    private final FilterRepository filterRepository;
    private final FilterMapper filterMapper;

    public List<Filter> getFilters(String userId) {
        return this.filterRepository.findByUserId(userId).stream().map(arg_0 -> ((FilterMapper)this.filterMapper).map2Model(arg_0)).collect(Collectors.toList());
    }

    public Filter findById(String filterId, String userId) {
        Filter filter = this.filterRepository.findById((Object)filterId).map(arg_0 -> ((FilterMapper)this.filterMapper).map2Model(arg_0)).orElseThrow(() -> new NoSuchElementException("filter (id=" + filterId + ")"));
        this.checkAccess(filter, userId);
        return filter;
    }

    public void deleteFilter(String filterId, String userId) {
        Filter filter = this.findById(filterId, userId);
        this.checkAccess(filter, userId);
        this.filterRepository.deleteById((Object)filterId);
    }

    public void saveFilter(Filter filter) {
        if (!StringUtils.isEmpty((CharSequence)filter.getFilterString())) {
            this.filterRepository.save((Object)this.filterMapper.map2Entity(filter));
        }
    }

    private void checkAccess(Filter filter, String userId) {
        if (!filter.getUserId().equals(userId)) {
            throw new IllegalResourceAccessException(String.format("Filter with id %s not accessable", filter.getId()));
        }
    }

    public PersistentFilterService(FilterRepository filterRepository, FilterMapper filterMapper) {
        this.filterRepository = filterRepository;
        this.filterMapper = filterMapper;
    }
}

