/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.humantask.api.resource;

import io.muenchendigital.digiwf.humantask.api.mapper.HumanTaskApiMapper;
import io.muenchendigital.digiwf.humantask.api.transport.CompleteTO;
import io.muenchendigital.digiwf.humantask.api.transport.FollowUpTO;
import io.muenchendigital.digiwf.humantask.api.transport.HumanTaskDetailTO;
import io.muenchendigital.digiwf.humantask.api.transport.HumanTaskTO;
import io.muenchendigital.digiwf.humantask.api.transport.SaveTO;
import io.muenchendigital.digiwf.humantask.domain.model.HumanTaskDetail;
import io.muenchendigital.digiwf.humantask.domain.service.HumanTaskService;
import io.muenchendigital.digiwf.shared.security.AppAuthenticationProvider;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Transactional
@RequestMapping(value={"/rest/task"})
@Tag(name="HumanTaskRestController", description="API to load human tasks and perform actions on them")
public class HumanTaskRestController {
    private final HumanTaskService taskService;
    private final AppAuthenticationProvider authenticationProvider;
    private final HumanTaskApiMapper taskMapper;

    @GetMapping
    public Page<HumanTaskTO> getTasks(@RequestParam(value="page", defaultValue="0", required=false) @Min(value=0L) @Min(value=0L) int page, @RequestParam(value="size", defaultValue="50", required=false) @Min(value=1L) @Max(value=50L) @Min(value=1L) @Max(value=50L) int size, @RequestParam(value="query", required=false) @Nullable String query, @RequestParam(value="followUp", defaultValue="false", required=false) Boolean followUp) {
        PageRequest pageable = PageRequest.of((int)page, (int)size, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createdAt"}));
        return this.taskService.getTasksForUser(this.authenticationProvider.getCurrentUserId(), query, followUp, (Pageable)pageable).map(arg_0 -> ((HumanTaskApiMapper)this.taskMapper).map2TO(arg_0));
    }

    @GetMapping(value={"/group/open"})
    public Page<HumanTaskTO> getOpenGroupTasks(@RequestParam(value="page", defaultValue="0", required=false) @Min(value=0L) @Min(value=0L) int page, @RequestParam(value="size", defaultValue="50", required=false) @Min(value=1L) @Max(value=50L) @Min(value=1L) @Max(value=50L) int size, @RequestParam(value="query", required=false) @Nullable String query) {
        PageRequest pageable = PageRequest.of((int)page, (int)size, (Sort)Sort.by((String[])new String[]{"createdAt"}));
        return this.taskService.getOpenGroupTasks(this.authenticationProvider.getCurrentUserId(), this.authenticationProvider.getCurrentUserGroups(), query, (Pageable)pageable).map(arg_0 -> ((HumanTaskApiMapper)this.taskMapper).map2TO(arg_0));
    }

    @GetMapping(value={"/group/assigned"})
    public Page<HumanTaskTO> getAssignedGroupTasks(@RequestParam(value="page", defaultValue="0", required=false) @Min(value=0L) @Min(value=0L) int page, @RequestParam(value="size", defaultValue="50", required=false) @Min(value=1L) @Max(value=50L) @Min(value=1L) @Max(value=50L) int size, @RequestParam(value="query", required=false) @Nullable String query) {
        PageRequest pageable = PageRequest.of((int)page, (int)size, (Sort)Sort.by((String[])new String[]{"createdAt"}));
        return this.taskService.getAssignedGroupTasks(this.authenticationProvider.getCurrentUserId(), this.authenticationProvider.getCurrentUserGroups(), query, (Pageable)pageable).map(arg_0 -> ((HumanTaskApiMapper)this.taskMapper).map2TO(arg_0));
    }

    @GetMapping(value={"/{id}"}, produces={"application/json"})
    public HumanTaskDetailTO getTaskDetail(@PathVariable(value="id") @NotBlank String taskId) {
        HumanTaskDetail task = this.taskService.getDetail(taskId, this.authenticationProvider.getCurrentUserId(), this.authenticationProvider.getCurrentUserGroups());
        return this.taskMapper.map2TO(task);
    }

    @PutMapping
    public void saveTask(@Valid @RequestBody SaveTO saveTO) {
        this.taskService.saveTask(saveTO.getTaskId(), saveTO.getVariables(), this.authenticationProvider.getCurrentUserId());
    }

    @PostMapping
    public void completeTask(@Valid @RequestBody CompleteTO completeTO) {
        this.taskService.completeTask(completeTO.getTaskId(), completeTO.getVariables(), this.authenticationProvider.getCurrentUserId());
    }

    @PostMapping(value={"/followup"})
    public void followUpTask(@Valid @RequestBody FollowUpTO followUpTO) {
        this.taskService.followUp(followUpTO.getTaskId(), followUpTO.getFollowUpDate(), this.authenticationProvider.getCurrentUserId());
    }

    @PostMapping(value={"/assign/{id}"})
    public void assignTask(@PathVariable(value="id") String taskId) {
        this.taskService.assignTask(taskId, this.authenticationProvider.getCurrentUserId(), this.authenticationProvider.getCurrentUserGroups());
    }

    @PostMapping(value={"/cancel/{id}"})
    public void cancelTask(@PathVariable(value="id") String taskId) {
        this.taskService.cancelTask(taskId, this.authenticationProvider.getCurrentUserId());
    }

    public HumanTaskRestController(HumanTaskService taskService, AppAuthenticationProvider authenticationProvider, HumanTaskApiMapper taskMapper) {
        this.taskService = taskService;
        this.authenticationProvider = authenticationProvider;
        this.taskMapper = taskMapper;
    }
}

