/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.humantask.domain.service;

import io.muenchendigital.digiwf.engine.mapper.EngineDataMapper;
import io.muenchendigital.digiwf.json.serialization.JsonSerializationService;
import io.muenchendigital.digiwf.json.validation.JsonSchemaValidator;
import io.muenchendigital.digiwf.jsonschema.domain.model.JsonSchema;
import io.muenchendigital.digiwf.jsonschema.domain.service.JsonSchemaService;
import io.muenchendigital.digiwf.legacy.form.domain.model.Form;
import io.muenchendigital.digiwf.legacy.form.domain.service.FormService;
import io.muenchendigital.digiwf.legacy.shared.data.DataService;
import io.muenchendigital.digiwf.shared.exception.VariablesNotValidException;
import java.util.Map;
import java.util.Optional;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.task.Task;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class HumanTaskDataService {
    private static final Logger log = LoggerFactory.getLogger(HumanTaskDataService.class);
    private final DataService dataService;
    private final FormService formService;
    private final JsonSchemaService jsonSchemaService;
    private final JsonSerializationService serializationService;
    private final JsonSchemaValidator jsonSchemaValidator;
    private final TaskService taskService;
    private final EngineDataMapper engineDataMapper;

    public Map<String, Object> serializeGivenVariables(Task task, Map<String, Object> variables) {
        String formKey = task.getFormKey();
        for (Map.Entry<String, Object> variable : variables.entrySet()) {
            if (variable.getValue() != null) continue;
            variable.setValue("");
        }
        Optional form = this.formService.getForm(formKey);
        if (form.isPresent()) {
            Map filteredVariables = this.dataService.filterReadonly((Form)form.get(), variables);
            if (!this.formService.validateVariables(formKey, filteredVariables)) {
                throw new VariablesNotValidException("Not allowed");
            }
            return this.dataService.serializeVariables((Form)form.get(), filteredVariables);
        }
        JsonSchema jsonSchema = (JsonSchema)this.jsonSchemaService.getByKey((String)this.getSchemaKey(task.getId()).orElseThrow()).orElseThrow();
        return this.serializeData(jsonSchema, task, variables);
    }

    public Map<String, Object> getVariablesForTask(Task task) {
        Optional form = this.formService.getForm(task.getFormKey());
        if (form.isPresent()) {
            Map variables = this.taskService.getVariables(task.getId());
            return this.dataService.calculateDefaultValues((Form)form.get(), variables);
        }
        JsonSchema jsonSchema = (JsonSchema)this.jsonSchemaService.getByKey((String)this.getSchemaKey(task.getId()).orElseThrow()).orElseThrow();
        return this.engineDataMapper.mapToData(this.serializationService.deserializeData(jsonSchema.getSchemaMap(), (Map)this.taskService.getVariablesTyped(task.getId())));
    }

    public String getTaskDescription(String taskId) {
        Object variable = this.taskService.getVariable(taskId, "app_task_description");
        if (variable == null) {
            variable = this.taskService.getVariable(taskId, "digitalwf_task_description");
        }
        if (variable == null) {
            return "";
        }
        return variable.toString();
    }

    public Optional<String> getSchemaKey(String taskId) {
        return Optional.ofNullable(this.taskService.getVariable(taskId, "app_task_schema_key")).map(Object::toString);
    }

    public Optional<String> getVariable(String taskId, String key) {
        return Optional.ofNullable(this.taskService.getVariable(taskId, key)).map(Object::toString);
    }

    public Optional<String> getFileContext(String taskId) {
        return Optional.ofNullable(this.taskService.getVariable(taskId, "app_file_context")).map(Object::toString);
    }

    private Map<String, Object> serializeData(JsonSchema schema, Task task, Map<String, Object> variables) {
        JSONObject filteredData = this.serializationService.filter(schema.getSchemaMap(), variables, true);
        this.jsonSchemaValidator.validate(schema.getSchemaMap(), filteredData.toMap());
        Map taskData = this.mapTaskData(task);
        Map targetData = this.serializationService.deserializeData(schema.getSchemaMap(), taskData);
        Map serializedData = this.serializationService.merge(filteredData, new JSONObject(targetData));
        JSONObject defaultValue = this.serializationService.initialize(new JSONObject(schema.getSchema()).toString());
        Map serializedDataWithDefaultValues = this.serializationService.merge(new JSONObject(serializedData), defaultValue);
        return this.engineDataMapper.mapObjectsToVariables(serializedDataWithDefaultValues);
    }

    private Map<String, Object> mapTaskData(Task task) {
        return this.engineDataMapper.mapToData(this.taskService.getVariables(task.getId()));
    }

    public HumanTaskDataService(DataService dataService, FormService formService, JsonSchemaService jsonSchemaService, JsonSerializationService serializationService, JsonSchemaValidator jsonSchemaValidator, TaskService taskService, EngineDataMapper engineDataMapper) {
        this.dataService = dataService;
        this.formService = formService;
        this.jsonSchemaService = jsonSchemaService;
        this.serializationService = serializationService;
        this.jsonSchemaValidator = jsonSchemaValidator;
        this.taskService = taskService;
        this.engineDataMapper = engineDataMapper;
    }
}

