/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.humantask.domain.service;

import io.muenchendigital.digiwf.humantask.domain.service.HumanTaskDataService;
import io.muenchendigital.digiwf.humantask.domain.service.HumanTaskService;
import io.muenchendigital.digiwf.process.config.process.ProcessConfigFunctions;
import io.muenchendigital.digiwf.s3.integration.client.repository.DocumentStorageFolderRepository;
import io.muenchendigital.digiwf.shared.exception.IllegalResourceAccessException;
import io.muenchendigital.digiwf.shared.exception.NoFileContextException;
import io.muenchendigital.digiwf.shared.file.AbstractFileService;
import io.muenchendigital.digiwf.shared.file.presignedUrlAdapters.PresignedUrlAction;
import io.muenchendigital.digiwf.shared.file.presignedUrlAdapters.PresignedUrlAdapter;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Service;

@Service
public class HumanTaskFileService
extends AbstractFileService {
    private static final Logger log = LoggerFactory.getLogger(HumanTaskFileService.class);
    private final HumanTaskDataService humanTaskDataService;
    private final HumanTaskService humanTaskService;

    public HumanTaskFileService(DocumentStorageFolderRepository documentStorageFolderRepository, List<PresignedUrlAdapter> presignedUrlAdapters, ProcessConfigFunctions processConfigFunctions, HumanTaskService humanTaskService, HumanTaskDataService humanTaskDataService) {
        super(documentStorageFolderRepository, presignedUrlAdapters, processConfigFunctions);
        this.humanTaskDataService = humanTaskDataService;
        this.humanTaskService = humanTaskService;
    }

    public List<String> getFileNames(String taskId, String filePath, String userId, List<String> groups) {
        if (!this.humanTaskService.hasAccess(taskId, userId, groups)) {
            throw new AccessDeniedException("403 returned");
        }
        this.checkReadAccess(taskId, filePath);
        String fileContext = this.getFileContext(taskId);
        return super.getFileNames(filePath, fileContext, this.getDocumentStorageUrl(taskId));
    }

    public String getPresignedUrl(PresignedUrlAction action, String taskId, String filePath, String fileName, String userId, List<String> groups) {
        if (!this.humanTaskService.hasAccess(taskId, userId, groups)) {
            throw new AccessDeniedException("403 returned");
        }
        if (action.equals((Object)PresignedUrlAction.GET)) {
            this.checkReadAccess(taskId, filePath);
        } else {
            this.checkWriteAccess(taskId, filePath);
        }
        String fileContext = this.getFileContext(taskId);
        return super.getPresignedUrl(action, fileContext + "/" + filePath + "/" + fileName, this.getDocumentStorageUrl(taskId));
    }

    protected Optional<String> getDocumentStorageUrl(String taskId) {
        return this.humanTaskDataService.getVariable(taskId, "app_file_s3_sync_config");
    }

    private String getFileContext(String taskId) {
        return (String)this.humanTaskDataService.getFileContext(taskId).orElseThrow(() -> new NoFileContextException("No file context found for task"));
    }

    private void checkReadAccess(String identifier, String filePath) {
        try {
            this.checkAccess(identifier, filePath, "app_file_paths");
        }
        catch (IllegalResourceAccessException ex) {
            this.checkAccess(identifier, filePath, "app_file_paths_readonly");
        }
    }

    private void checkWriteAccess(String identifier, String filePath) {
        this.checkAccess(identifier, filePath, "app_file_paths");
    }

    private void checkAccess(String identifier, String filePath, String variable) {
        Optional filePaths = this.humanTaskDataService.getVariable(identifier, variable);
        if (filePaths.isEmpty()) {
            throw new IllegalResourceAccessException("No access to defined property");
        }
        Arrays.stream(((String)filePaths.get()).split(";")).filter(filePath::startsWith).findFirst().orElseThrow(() -> new IllegalResourceAccessException("No access to defined property"));
    }
}

