/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.humantask.infrastructure.repository;

import io.muenchendigital.digiwf.humantask.infrastructure.entity.TaskInfoEntity;
import io.muenchendigital.digiwf.humantask.infrastructure.entity.camunda.ActRuIdentityLinkEntity;
import io.muenchendigital.digiwf.humantask.infrastructure.entity.camunda.ActRuTaskEntity;
import io.muenchendigital.digiwf.humantask.infrastructure.repository.ActRuTaskCriteriaProvider;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

@Repository
public class ActRuGroupTaskSearchRepository
extends ActRuTaskCriteriaProvider {
    private final EntityManager em;

    public Page<ActRuTaskEntity> search(String userId, List<String> lowerCaseGroups, String searchQuery, Boolean assigned, Pageable pageable) {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery resultQuery = cb.createQuery(ActRuTaskEntity.class);
        Root actRuTask = resultQuery.from(ActRuTaskEntity.class);
        Join taskInfo = actRuTask.join("taskInfoEntity");
        Join identityLinks = actRuTask.join("actRuIdentities");
        Predicate[] predicates = this.getPredicates(userId, lowerCaseGroups, searchQuery, assigned, cb, actRuTask, taskInfo, identityLinks);
        List orders = this.getOrderList(pageable, cb, actRuTask);
        resultQuery.where(predicates).orderBy(orders).distinct(true);
        List result = this.em.createQuery(resultQuery).setFirstResult((int)pageable.getOffset()).setMaxResults(pageable.getPageSize()).getResultList();
        CriteriaQuery countQuery = cb.createQuery(Long.class);
        Root actRuTaskCount = countQuery.from(ActRuTaskEntity.class);
        actRuTaskCount.join("taskInfoEntity");
        actRuTaskCount.join("actRuIdentities");
        countQuery.select((Selection)cb.count((Expression)actRuTaskCount)).where(predicates);
        Long count = (Long)this.em.createQuery(countQuery).getSingleResult();
        return new PageImpl(result, pageable, count.longValue());
    }

    private Predicate[] getPredicates(String userId, List<String> lowerCaseGroups, @Nullable String searchQuery, Boolean isAssigned, CriteriaBuilder cb, Root<ActRuTaskEntity> actRuTask, Join<ActRuTaskEntity, TaskInfoEntity> taskInfo, Join<ActRuTaskEntity, ActRuIdentityLinkEntity> identityLinks) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (isAssigned.booleanValue()) {
            predicates.add(this.getAssignedPredicate(userId, lowerCaseGroups, cb, actRuTask, identityLinks));
        } else {
            predicates.add(this.getUnAssignedPredicate(userId, lowerCaseGroups, cb, actRuTask, identityLinks));
        }
        if (searchQuery != null && !searchQuery.isBlank()) {
            predicates.add(this.getSearchQueryPredicates(searchQuery, cb, actRuTask, taskInfo));
        }
        return predicates.toArray(new Predicate[0]);
    }

    private Predicate getAssignedPredicate(String userId, List<String> lowerCaseGroups, CriteriaBuilder cb, Root<ActRuTaskEntity> actRuTask, Join<ActRuTaskEntity, ActRuIdentityLinkEntity> identityLinks) {
        CriteriaBuilder.In inClause = cb.in(cb.lower((Expression)identityLinks.get("groupId")));
        for (String lowerCaseGroup : lowerCaseGroups) {
            inClause.value((Object)lowerCaseGroup);
        }
        return cb.and(new Predicate[]{cb.isNotNull((Expression)actRuTask.get("assignee")), cb.equal((Expression)identityLinks.get("type"), (Object)"candidate"), cb.or((Expression)inClause, (Expression)cb.equal((Expression)identityLinks.get("userId"), (Object)userId))});
    }

    private Predicate getUnAssignedPredicate(String userId, List<String> lowerCaseGroups, CriteriaBuilder cb, Root<ActRuTaskEntity> actRuTask, Join<ActRuTaskEntity, ActRuIdentityLinkEntity> identityLinks) {
        CriteriaBuilder.In inGroupClause = cb.in(cb.lower((Expression)identityLinks.get("groupId")));
        for (String lowerCaseGroup : lowerCaseGroups) {
            inGroupClause.value((Object)lowerCaseGroup);
        }
        return cb.and(new Predicate[]{cb.isNull((Expression)actRuTask.get("assignee")), cb.equal((Expression)identityLinks.get("type"), (Object)"candidate"), cb.or((Expression)inGroupClause, (Expression)cb.equal((Expression)identityLinks.get("userId"), (Object)userId))});
    }

    public ActRuGroupTaskSearchRepository(EntityManager em) {
        this.em = em;
    }
}

