/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.humantask.infrastructure.repository;

import io.muenchendigital.digiwf.humantask.infrastructure.entity.TaskInfoEntity;
import io.muenchendigital.digiwf.humantask.infrastructure.entity.camunda.ActRuTaskEntity;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.data.domain.Pageable;

public abstract class ActRuTaskCriteriaProvider {
    public List<Order> getOrderList(Pageable pageable, CriteriaBuilder cb, Root<ActRuTaskEntity> actRuTask) {
        return pageable.getSort().stream().map(sort -> {
            if (sort.getDirection().isAscending()) {
                return cb.asc((Expression)actRuTask.get(sort.getProperty()));
            }
            return cb.desc((Expression)actRuTask.get(sort.getProperty()));
        }).collect(Collectors.toList());
    }

    public Predicate getSearchQueryPredicates(String searchQuery, CriteriaBuilder cb, Root<ActRuTaskEntity> actRuTask, Join<ActRuTaskEntity, TaskInfoEntity> taskInfo) {
        String lowerSearchTerm = searchQuery.toLowerCase();
        Predicate namePredicate = cb.like(cb.lower((Expression)actRuTask.get("name")), "%" + lowerSearchTerm + "%");
        Predicate descriptionPredicate = cb.like(cb.lower((Expression)taskInfo.get("description")), "%" + lowerSearchTerm + "%");
        Predicate definitionNamePredicate = cb.like(cb.lower((Expression)taskInfo.get("definitionName")), "%" + lowerSearchTerm + "%");
        return cb.or(new Predicate[]{namePredicate, descriptionPredicate, definitionNamePredicate});
    }
}

