/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.humantask.process.listener;

import io.holunda.camunda.bpm.data.CamundaBpmData;
import io.holunda.camunda.bpm.data.factory.VariableFactory;
import io.muenchendigital.digiwf.legacy.user.domain.model.User;
import io.muenchendigital.digiwf.legacy.user.domain.service.UserService;
import io.muenchendigital.digiwf.process.instance.domain.service.ServiceInstanceAuthService;
import io.muenchendigital.digiwf.shared.security.AppAuthenticationProvider;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.delegate.DelegateTask;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class UserTaskCompleteListener {
    private final RuntimeService runtimeService;
    private final UserService userService;
    private final AppAuthenticationProvider camundaUserAuthenticationProvider;
    private final ServiceInstanceAuthService serviceInstanceAuthService;
    @Deprecated
    private static final VariableFactory<String> ASSIGN_USER_TO_PROCESSINSTANCE = CamundaBpmData.stringVariable((String)"digitalwf_assign_user_to_processinstance");
    private static final VariableFactory<String> APP_ASSIGN_USER_TO_PROCESSINSTANCE = CamundaBpmData.stringVariable((String)"app_assign_user_to_processinstance");

    @EventListener
    public void delegateTask(DelegateTask delegateTask) {
        if (delegateTask.getEventName().equals("complete")) {
            User user = this.userService.getUser(this.camundaUserAuthenticationProvider.getCurrentUserId());
            SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy HH:mm");
            this.runtimeService.setVariable(delegateTask.getProcessInstanceId(), delegateTask.getTaskDefinitionKey() + "_complete_time", (Object)format.format(new Date()));
            this.runtimeService.setVariable(delegateTask.getProcessInstanceId(), delegateTask.getTaskDefinitionKey() + "_complete_user", (Object)user.getLhmObjectId());
            this.runtimeService.setVariable(delegateTask.getProcessInstanceId(), delegateTask.getTaskDefinitionKey() + "_complete_user_name", (Object)(user.getForename() + " " + user.getSurname() + ", " + user.getOu()));
            Optional assign = ASSIGN_USER_TO_PROCESSINSTANCE.from((VariableScope)delegateTask).getOptional();
            if (assign.isPresent() && "true".equals(assign.get())) {
                this.serviceInstanceAuthService.createAuthorization(delegateTask.getProcessInstanceId(), user.getLhmObjectId());
            }
            if ((assign = APP_ASSIGN_USER_TO_PROCESSINSTANCE.from((VariableScope)delegateTask).getOptional()).isPresent() && "true".equals(assign.get())) {
                this.serviceInstanceAuthService.createAuthorization(delegateTask.getProcessInstanceId(), user.getLhmObjectId());
            }
        }
    }

    public UserTaskCompleteListener(RuntimeService runtimeService, UserService userService, AppAuthenticationProvider camundaUserAuthenticationProvider, ServiceInstanceAuthService serviceInstanceAuthService) {
        this.runtimeService = runtimeService;
        this.userService = userService;
        this.camundaUserAuthenticationProvider = camundaUserAuthenticationProvider;
        this.serviceInstanceAuthService = serviceInstanceAuthService;
    }
}

