/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.humantask.process.listener;

import io.holunda.camunda.bpm.data.CamundaBpmData;
import io.holunda.camunda.bpm.data.factory.VariableFactory;
import io.muenchendigital.digiwf.humantask.process.ProcessTaskConstants;
import io.muenchendigital.digiwf.legacy.mailing.domain.model.MailTemplate;
import io.muenchendigital.digiwf.legacy.mailing.domain.service.MailingService;
import io.muenchendigital.digiwf.legacy.user.domain.model.User;
import io.muenchendigital.digiwf.legacy.user.domain.service.UserService;
import io.muenchendigital.digiwf.shared.properties.DigitalWFProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.delegate.DelegateTask;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.task.IdentityLink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Profile;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"!no-mail"})
public class UserTaskNotificationListener {
    private static final Logger log = LoggerFactory.getLogger(UserTaskNotificationListener.class);
    private final RepositoryService repositoryService;
    private final MailingService mailingService;
    private final UserService userService;
    private final DigitalWFProperties properties;
    @Deprecated
    private static final VariableFactory<String> NOTIFICATION_SEND = CamundaBpmData.stringVariable((String)"digitalwf_notification_send");
    @Deprecated
    private static final VariableFactory<String> NOTIFICATION_SEND_ASSIGNEE = CamundaBpmData.stringVariable((String)"digitalwf_notification_send_assignee");
    @Deprecated
    private static final VariableFactory<String> NOTIFICATION_SEND_CANDIDATE_USERS = CamundaBpmData.stringVariable((String)"digitalwf_notification_send_candidate_users");
    @Deprecated
    private static final VariableFactory<String> NOTIFICATION_SEND_CANDIDATE_GROUPS = CamundaBpmData.stringVariable((String)"digitalwf_notification_send_candidate_groups");

    @EventListener
    public void delegateTask(DelegateTask delegateTask) throws Exception {
        if (delegateTask.getEventName().equals("create")) {
            log.debug("Notification for created task: {}", (Object)delegateTask.getName());
            Optional notify = NOTIFICATION_SEND.from((VariableScope)delegateTask).getOptional();
            if (notify.isPresent()) {
                if ("true".equals(notify.get())) {
                    this.notifyAssignee(delegateTask);
                }
                return;
            }
            Optional notifyAssignee = NOTIFICATION_SEND_ASSIGNEE.from((VariableScope)delegateTask).getOptional();
            Optional notifyAssigneeV02 = ProcessTaskConstants.APP_NOTIFICATION_SEND_ASSIGNEE.from((VariableScope)delegateTask).getOptional();
            if (!(notifyAssignee.isPresent() && !"true".equals(notifyAssignee.get()) || notifyAssigneeV02.isPresent() && !"true".equals(notifyAssigneeV02.get()))) {
                this.notifyAssignee(delegateTask);
            }
            Optional notifyCandidateUsers = NOTIFICATION_SEND_CANDIDATE_USERS.from((VariableScope)delegateTask).getOptional();
            Optional notifyCandidateUsersV02 = ProcessTaskConstants.APP_NOTIFICATION_SEND_CANDIDATE_USERS.from((VariableScope)delegateTask).getOptional();
            if (!(notifyCandidateUsers.isPresent() && !"true".equals(notifyCandidateUsers.get()) || notifyCandidateUsersV02.isPresent() && !"true".equals(notifyCandidateUsersV02.get()))) {
                this.notifyCandidateUsers(delegateTask);
            }
            Optional notifyCandidateGroups = NOTIFICATION_SEND_CANDIDATE_GROUPS.from((VariableScope)delegateTask).getOptional();
            Optional notifyCandidateGroupsV02 = ProcessTaskConstants.APP_NOTIFICATION_SEND_CANDIDATE_GROUPS.from((VariableScope)delegateTask).getOptional();
            if (!(notifyCandidateGroups.isPresent() && !"true".equals(notifyCandidateGroups.get()) || notifyCandidateGroupsV02.isPresent() && !"true".equals(notifyCandidateGroupsV02.get()))) {
                this.notifyCandidateGroups(delegateTask);
            }
        }
    }

    private void notifyAssignee(DelegateTask delegateTask) throws Exception {
        if (StringUtils.isBlank((CharSequence)delegateTask.getAssignee())) {
            return;
        }
        try {
            String processName = this.getProcessName(delegateTask.getProcessDefinitionId());
            String address = this.getMailAddress(delegateTask.getAssignee());
            Object body = "Sie haben eine Aufgabe in DigiWF.";
            if (!processName.isBlank()) {
                body = "Sie haben eine Aufgabe in DigiWF (" + processName + ").";
            }
            MailTemplate mail = ((MailTemplate.MailTemplateBuilder)((MailTemplate.MailTemplateBuilder)((MailTemplate.MailTemplateBuilder)MailTemplate.builder().receivers(address)).body((String)body)).buttonText("Aufgabe \u00f6ffnen").link(this.properties.getFrontendUrl() + "/#/task/" + delegateTask.getId()).subject("Es liegt eine neue Aufgabe f\u00fcr Sie bereit")).build();
            log.debug("Sending notification to {}", (Object)address);
            this.mailingService.sendMailTemplateWithLink(mail);
        }
        catch (Exception ex) {
            log.warn("Notification failed: {}", (Object)ex.getMessage());
            throw ex;
        }
    }

    private void notifyCandidateUsers(DelegateTask delegateTask) {
        if (delegateTask.getCandidates().isEmpty()) {
            return;
        }
        ArrayList<String> addresses = new ArrayList<String>();
        for (IdentityLink link : delegateTask.getCandidates()) {
            if (!"candidate".equals(link.getType()) || StringUtils.isEmpty((CharSequence)link.getUserId())) continue;
            try {
                String address = this.getMailAddress(link.getUserId());
                addresses.add(address);
            }
            catch (Exception ex) {
                log.warn(ex.toString());
            }
        }
        if (!addresses.isEmpty()) {
            this.sendGroupMail(addresses, delegateTask.getId(), delegateTask.getProcessDefinitionId());
        }
    }

    private void notifyCandidateGroups(DelegateTask delegateTask) {
        if (delegateTask.getCandidates().isEmpty()) {
            return;
        }
        ArrayList<String> addresses = new ArrayList<String>();
        for (IdentityLink link : delegateTask.getCandidates()) {
            if (!"candidate".equals(link.getType()) || StringUtils.isEmpty((CharSequence)link.getGroupId())) continue;
            try {
                Optional ou = this.userService.getOuByShortName(link.getGroupId());
                if (!ou.isPresent()) {
                    log.warn("lhmObject {} was not found", (Object)link.getGroupId());
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)((User)ou.get()).getEmail())) {
                    log.warn("lhmObject {} has no mail address", (Object)link.getGroupId());
                    continue;
                }
                addresses.add(((User)ou.get()).getEmail());
            }
            catch (Exception ex) {
                log.warn(ex.toString());
            }
        }
        if (!addresses.isEmpty()) {
            this.sendGroupMail(addresses, delegateTask.getId(), delegateTask.getProcessDefinitionId());
        }
    }

    private String getMailAddress(String receiver) {
        User user = this.userService.getUser(receiver);
        if (!StringUtils.isEmpty((CharSequence)user.getEmail())) {
            return user.getEmail();
        }
        throw new RuntimeException("lhmObject {} has no mail address" + receiver);
    }

    private void sendGroupMail(List<String> addresses, String taskId, String processDefinitionId) {
        try {
            String processName = this.getProcessName(processDefinitionId);
            Object body = "Sie haben eine Gruppenaufgabe in DigiWF.";
            if (!processName.isBlank()) {
                body = "Sie haben eine Gruppenaufgabe in DigiWF (" + processName + ").";
            }
            String addresslist = String.join((CharSequence)",", addresses);
            MailTemplate mail = ((MailTemplate.MailTemplateBuilder)((MailTemplate.MailTemplateBuilder)((MailTemplate.MailTemplateBuilder)MailTemplate.builder().receivers(addresslist)).body((String)body)).buttonText("Gruppenaufgabe \u00f6ffnen").link(this.properties.getFrontendUrl() + "/#/opengrouptask/" + taskId).subject("Es liegt eine neue Gruppenaufgabe f\u00fcr Sie bereit")).build();
            log.debug("Sending notification to {}", (Object)addresslist);
            this.mailingService.sendMailTemplateWithLink(mail);
        }
        catch (Exception ex) {
            log.warn("Notification failed: {}", (Object)ex.getMessage());
        }
    }

    private String getProcessName(String processDefinitionId) {
        String processName = "";
        try {
            ProcessDefinition procDef = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(processDefinitionId).singleResult();
            if (procDef.getName() != null && !procDef.getName().isBlank()) {
                processName = procDef.getName();
            } else if (procDef.getKey() != null && !procDef.getKey().isBlank()) {
                processName = procDef.getKey();
            }
        }
        catch (Exception ex) {
            log.warn("Reading ProcessDefinition failed: {}", (Object)ex.getMessage());
        }
        return processName;
    }

    public UserTaskNotificationListener(RepositoryService repositoryService, MailingService mailingService, UserService userService, DigitalWFProperties properties) {
        this.repositoryService = repositoryService;
        this.mailingService = mailingService;
        this.userService = userService;
        this.properties = properties;
    }
}

