/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.jsonschema.deployment;

import com.google.gson.Gson;
import io.muenchendigital.digiwf.jsonschema.domain.model.JsonSchema;
import io.muenchendigital.digiwf.jsonschema.domain.service.JsonSchemaService;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.FileCopyUtils;

@Component
@ConditionalOnProperty(value={"digiwf.jsonschema.autodeploy"})
public class JsonSchemaAutodeploymentHandler {
    private static final Logger log = LoggerFactory.getLogger(JsonSchemaAutodeploymentHandler.class);
    private final ResourceLoader resourceLoader;
    private final JsonSchemaService jsonSchemaService;

    @PostConstruct
    public void autoDeploy() throws IOException {
        Resource[] resources = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)this.resourceLoader).getResources("classpath:**/*.schema.json");
        ArrayList<JsonSchema> schemas = new ArrayList<JsonSchema>();
        for (Resource resource : resources) {
            try {
                schemas.add(this.map(resource));
            }
            catch (Exception error) {
                log.error("The schema could no be loaded: {}", (Object)resource.getFilename(), (Object)error);
            }
        }
        for (JsonSchema schema : schemas) {
            try {
                this.jsonSchemaService.createJsonSchema(schema);
            }
            catch (Exception error) {
                log.error("The schema could no be loaded: {}", (Object)schema.getKey(), (Object)error);
            }
        }
    }

    private JsonSchema map(Resource resource) throws IOException {
        String json = this.asString(resource);
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        Map schemaMap = (Map)new Gson().fromJson(json, type);
        return new JsonSchema(schemaMap.get("key").toString(), new Gson().toJson(schemaMap.get("schema")));
    }

    private String asString(Resource resource) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(resource.getInputStream(), StandardCharsets.UTF_8);){
            String string = FileCopyUtils.copyToString((Reader)reader);
            return string;
        }
    }

    public JsonSchemaAutodeploymentHandler(ResourceLoader resourceLoader, JsonSchemaService jsonSchemaService) {
        this.resourceLoader = resourceLoader;
        this.jsonSchemaService = jsonSchemaService;
    }
}

