/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.jsonschema.deployment.domain.service;

import io.muenchendigital.digiwf.deployment.api.enums.DeploymentStatus;
import io.muenchendigital.digiwf.deployment.domain.model.DeploymentStatusModel;
import io.muenchendigital.digiwf.jsonschema.deployment.domain.model.SchemaDeploymentModel;
import io.muenchendigital.digiwf.jsonschema.domain.model.JsonSchema;
import io.muenchendigital.digiwf.jsonschema.domain.service.JsonSchemaService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SchemaDeploymentService {
    private static final Logger log = LoggerFactory.getLogger(SchemaDeploymentService.class);
    private final JsonSchemaService jsonSchemaService;

    public DeploymentStatusModel deploy(SchemaDeploymentModel deploymentModel) {
        try {
            JsonSchema jsonSchema = JsonSchema.builder().key(deploymentModel.getVersionId()).schema(deploymentModel.getFile()).build();
            this.jsonSchemaService.createJsonSchema(jsonSchema);
            log.info("Deployed {} successfully", (Object)jsonSchema.getKey());
            return new DeploymentStatusModel(DeploymentStatus.SUCCESSFUL.getValue(), deploymentModel.getDeploymentId(), "Deployment was successful!");
        }
        catch (RuntimeException exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            return new DeploymentStatusModel(DeploymentStatus.FAILURE.getValue(), deploymentModel.getDeploymentId(), "Deployment failed with error " + exception.getMessage());
        }
    }

    public SchemaDeploymentService(JsonSchemaService jsonSchemaService) {
        this.jsonSchemaService = jsonSchemaService;
    }
}

