/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.legacy.dms.alwdms.api.resource;

import io.muenchendigital.digiwf.legacy.dms.alwdms.api.mapper.AlwMetadataTOMapper;
import io.muenchendigital.digiwf.legacy.dms.alwdms.api.transport.AlwMetaDataTO;
import io.muenchendigital.digiwf.legacy.dms.alwdms.api.transport.GetAlwMetadataTO;
import io.muenchendigital.digiwf.legacy.dms.alwdms.domain.model.AlwMetadata;
import io.muenchendigital.digiwf.legacy.dms.alwdms.domain.service.AlwDmsService;
import io.muenchendigital.digiwf.shared.security.AppAuthenticationProvider;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.validation.Valid;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@Transactional
@RequestMapping(value={"/rest/alwdms"})
@Tag(name="AlwDmsRestController", description="API to interact with the alw dms")
public class AlwDmsRestController {
    private final AlwDmsService kvrDmsService;
    private final AlwMetadataTOMapper kvrMetaDataMapper;
    private final AppAuthenticationProvider authenticationProvider;

    @PostMapping(value={"/metadata"})
    public ResponseEntity<AlwMetaDataTO> getMetadata(@RequestBody @Valid GetAlwMetadataTO request) {
        AlwMetadata metadata = this.kvrDmsService.getContentMetadata(this.authenticationProvider.getCurrentUserId(), request.getUrl());
        return ResponseEntity.ok((Object)((AlwMetaDataTO)this.kvrMetaDataMapper.map2TO((Object)metadata)));
    }

    public AlwDmsRestController(AlwDmsService kvrDmsService, AlwMetadataTOMapper kvrMetaDataMapper, AppAuthenticationProvider authenticationProvider) {
        this.kvrDmsService = kvrDmsService;
        this.kvrMetaDataMapper = kvrMetaDataMapper;
        this.authenticationProvider = authenticationProvider;
    }
}

