/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.legacy.dms.muc.domain.service;

import io.muenchendigital.digiwf.legacy.dms.muc.domain.model.Dokument;
import io.muenchendigital.digiwf.legacy.dms.muc.domain.model.EinAusgehend;
import io.muenchendigital.digiwf.legacy.dms.muc.domain.model.Metadata;
import io.muenchendigital.digiwf.legacy.dms.muc.domain.model.NeueSachakte;
import io.muenchendigital.digiwf.legacy.dms.muc.domain.model.NeuerVorgang;
import io.muenchendigital.digiwf.legacy.dms.muc.domain.model.NeuesDokument;
import io.muenchendigital.digiwf.legacy.dms.muc.domain.model.NeuesSchriftstueck;
import io.muenchendigital.digiwf.legacy.dms.muc.domain.model.Sachakte;
import io.muenchendigital.digiwf.legacy.dms.muc.domain.model.Schriftstueck;
import io.muenchendigital.digiwf.legacy.dms.muc.domain.model.Vorgang;
import io.muenchendigital.digiwf.legacy.dms.muc.external.client.DmsClient;
import io.muenchendigital.digiwf.legacy.dms.muc.external.transport.DMSObjectClass;
import io.muenchendigital.digiwf.legacy.dms.muc.external.transport.DMSSearchResult;
import io.muenchendigital.digiwf.legacy.dms.muc.properties.DmsProperties;
import io.muenchendigital.digiwf.legacy.user.domain.service.UserService;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpServerErrorException;

@Service
public class DmsService {
    private static final Logger log = LoggerFactory.getLogger(DmsService.class);
    private final DmsClient dmsClient;
    private final UserService userService;
    private final DmsProperties dmsProperties;

    public Metadata getMetadataByUrl(String userId, String url) {
        return this.getMetadata(userId, this.parseUrl(url));
    }

    public Metadata getMetadata(String userId, String coo) {
        String username = this.getUsername(userId);
        return this.dmsClient.readContentMetadata(coo, username);
    }

    public Optional<String> searchSachakte(String searchString, String userId) throws Exception {
        String username = this.getUsername(userId);
        try {
            String sachakteCoo = this.searchObjectWithUser(searchString, DMSObjectClass.Sachakte, username);
            log.debug("Sachakte searched: {}", (Object)sachakteCoo);
            return Optional.ofNullable(sachakteCoo);
        }
        catch (IllegalStateException e) {
            return Optional.empty();
        }
    }

    public Sachakte createSachakte(String sachakteTitel, String aktenplanName, String userId) throws Exception {
        String username = this.getUsername(userId);
        String aktenPlanCoo = this.searchObjectWithUser(aktenplanName, DMSObjectClass.Aktenplaneintrag, username);
        NeueSachakte sachakte = new NeueSachakte(aktenPlanCoo, sachakteTitel);
        Sachakte result = this.dmsClient.createSachakteWithUser(sachakte, username);
        log.debug("Sachakte created: {}", (Object)result.getCoo());
        return result;
    }

    public Vorgang createVorgang(String vorgangTitle, String sachakteId, String userId) throws Exception {
        String username = this.getUsername(userId);
        NeuerVorgang neuerVorgang = new NeuerVorgang(sachakteId, vorgangTitle, "");
        Vorgang vorgang = this.dmsClient.createVorgang(neuerVorgang, username);
        log.debug("Vorgang created: {}", (Object)vorgang.getCoo());
        return vorgang;
    }

    public Dokument createDokument(String documenTitle, String vorgangCoo, String userId) throws Exception {
        String username = this.getUsername(userId);
        NeuesDokument document = NeuesDokument.builder().betreff(documenTitle).einAusgehend(EinAusgehend.EINGEHEND).kurzname(documenTitle).vorgangId(vorgangCoo).build();
        Dokument resultDocument = this.dmsClient.createDokument(document, username);
        log.debug("Dokument created: {}", (Object)resultDocument.getCoo());
        return resultDocument;
    }

    public void updateDocument(Dokument dokument, List<NeuesSchriftstueck> schriftstuecke, String userId) throws Exception {
        String username = this.getUsername(userId);
        this.dmsClient.updateEingehendesDokument(dokument, schriftstuecke, username);
    }

    public List<Schriftstueck> getAllSchrifstuecke(String dokumentCOO, String userId) throws Exception {
        String username = this.getUsername(userId);
        return this.dmsClient.getAllSchriftstuecke(dokumentCOO, username);
    }

    public Dokument createDokument(String documenTitle, String vorgangCoo, String userId, List<NeuesSchriftstueck> schriftstuecke) throws Exception {
        String username = this.getUsername(userId);
        NeuesDokument document = NeuesDokument.builder().betreff(documenTitle).einAusgehend(EinAusgehend.EINGEHEND).kurzname(documenTitle).vorgangId(vorgangCoo).schriftstuecke(schriftstuecke).build();
        Dokument resultDocument = this.dmsClient.createDokument(document, username);
        log.debug("Dokument created: {}", (Object)resultDocument.getCoo());
        return resultDocument;
    }

    public void cancelDocument(@NotBlank String userId, @NotBlank String documentCOO) throws Exception {
        String username = this.getUsername(userId);
        this.dmsClient.cancelDokument(username, documentCOO);
    }

    public void updateSchriftstueck(Schriftstueck schriftstueck, String userId) throws Exception {
        String username = this.getUsername(userId);
        this.dmsClient.updateSchriftstueck(schriftstueck, username);
        log.debug("Dokument updated: {}", (Object)schriftstueck.getCoo());
    }

    public void depositVorgang(@NotBlank String vorgangCoo, @NotBlank String userId) throws Exception {
        String username = this.getUsername(userId);
        this.dmsClient.depositVorgang(vorgangCoo, username);
    }

    public List<Metadata> getMetadata(List<Schriftstueck> schriftstuecke, String userId) {
        String username = this.getUsername(userId);
        return schriftstuecke.stream().map(obj -> this.dmsClient.readContentMetadata(obj.getCoo(), username)).collect(Collectors.toList());
    }

    public Schriftstueck readSchriftstueck(String userId, String url) {
        String username = this.getUsername(userId);
        try {
            return this.dmsClient.readSchriftstueck(username, this.parseUrl(url));
        }
        catch (Exception e) {
            throw new HttpServerErrorException(HttpStatus.INTERNAL_SERVER_ERROR, String.format("Schriftstueck could no be read. User: %s Obj: %s", userId, url));
        }
    }

    private String searchObjectWithUser(String objectName, DMSObjectClass dmsObjectClass, String username) throws Exception {
        List results = this.dmsClient.searchObjectWithUser(objectName, dmsObjectClass, username);
        if (results.isEmpty()) {
            return null;
        }
        return ((DMSSearchResult)results.get((int)0)).objaddress;
    }

    private String getUsername(String userLogin) {
        String defaultUser = this.dmsProperties.getDefaultUser();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{defaultUser})) {
            return this.userService.getUser(defaultUser).getUsername();
        }
        return this.userService.getUser(userLogin).getUsername();
    }

    private String urlEncode(String string) {
        try {
            return URLEncoder.encode(string, Charset.defaultCharset().name());
        }
        catch (UnsupportedEncodingException e) {
            log.warn("Url encoding failed for {}", (Object)string, (Object)e);
            return string;
        }
    }

    private String parseUrl(String url) {
        return url.substring(url.lastIndexOf("/mx/") + 4);
    }

    public DmsService(DmsClient dmsClient, UserService userService, DmsProperties dmsProperties) {
        this.dmsClient = dmsClient;
        this.userService = userService;
        this.dmsProperties = dmsProperties;
    }
}

