/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.legacy.dms.muc.external.client;

import com.fabasoft.schemas.websvc.lhmbai_15_1700_giwsd.ArrayOfLHMBAI151700GIAttachmentType;
import com.fabasoft.schemas.websvc.lhmbai_15_1700_giwsd.CancelObjectGI;
import com.fabasoft.schemas.websvc.lhmbai_15_1700_giwsd.CancelObjectGIResponse;
import com.fabasoft.schemas.websvc.lhmbai_15_1700_giwsd.CreateFileGI;
import com.fabasoft.schemas.websvc.lhmbai_15_1700_giwsd.CreateFileGIResponse;
import com.fabasoft.schemas.websvc.lhmbai_15_1700_giwsd.CreateIncomingGI;
import com.fabasoft.schemas.websvc.lhmbai_15_1700_giwsd.CreateIncomingGIResponse;
import com.fabasoft.schemas.websvc.lhmbai_15_1700_giwsd.CreateOutgoingGI;
import com.fabasoft.schemas.websvc.lhmbai_15_1700_giwsd.CreateOutgoingGIResponse;
import com.fabasoft.schemas.websvc.lhmbai_15_1700_giwsd.CreateProcedureGI;
import com.fabasoft.schemas.websvc.lhmbai_15_1700_giwsd.CreateProcedureGIResponse;
import com.fabasoft.schemas.websvc.lhmbai_15_1700_giwsd.DepositObjectGI;
import com.fabasoft.schemas.websvc.lhmbai_15_1700_giwsd.DepositObjectGIResponse;
import com.fabasoft.schemas.websvc.lhmbai_15_1700_giwsd.LHMBAI151700GIAttachmentType;
import com.fabasoft.schemas.websvc.lhmbai_15_1700_giwsd.LHMBAI151700GIObjectType;
import com.fabasoft.schemas.websvc.lhmbai_15_1700_giwsd.LHMBAI151700GIWSDSoap;
import com.fabasoft.schemas.websvc.lhmbai_15_1700_giwsd.ReadContentObjectGI;
import com.fabasoft.schemas.websvc.lhmbai_15_1700_giwsd.ReadContentObjectGIResponse;
import com.fabasoft.schemas.websvc.lhmbai_15_1700_giwsd.ReadContentObjectMetaDataGI;
import com.fabasoft.schemas.websvc.lhmbai_15_1700_giwsd.ReadContentObjectMetaDataGIResponse;
import com.fabasoft.schemas.websvc.lhmbai_15_1700_giwsd.ReadDocumentGIObjects;
import com.fabasoft.schemas.websvc.lhmbai_15_1700_giwsd.ReadDocumentGIObjectsResponse;
import com.fabasoft.schemas.websvc.lhmbai_15_1700_giwsd.SearchObjNameGI;
import com.fabasoft.schemas.websvc.lhmbai_15_1700_giwsd.SearchObjNameGIResponse;
import com.fabasoft.schemas.websvc.lhmbai_15_1700_giwsd.UpdateContentObjectGI;
import com.fabasoft.schemas.websvc.lhmbai_15_1700_giwsd.UpdateContentObjectGIResponse;
import com.fabasoft.schemas.websvc.lhmbai_15_1700_giwsd.UpdateIncomingGI;
import com.fabasoft.schemas.websvc.lhmbai_15_1700_giwsd.UpdateIncomingGIResponse;
import io.muenchendigital.digiwf.legacy.dms.muc.domain.model.Dokument;
import io.muenchendigital.digiwf.legacy.dms.muc.domain.model.Metadata;
import io.muenchendigital.digiwf.legacy.dms.muc.domain.model.NeueSachakte;
import io.muenchendigital.digiwf.legacy.dms.muc.domain.model.NeuerVorgang;
import io.muenchendigital.digiwf.legacy.dms.muc.domain.model.NeuesDokument;
import io.muenchendigital.digiwf.legacy.dms.muc.domain.model.NeuesSchriftstueck;
import io.muenchendigital.digiwf.legacy.dms.muc.domain.model.Sachakte;
import io.muenchendigital.digiwf.legacy.dms.muc.domain.model.Schriftstueck;
import io.muenchendigital.digiwf.legacy.dms.muc.domain.model.Vorgang;
import io.muenchendigital.digiwf.legacy.dms.muc.external.client.DmsClient;
import io.muenchendigital.digiwf.legacy.dms.muc.external.mapper.DMSSearchResultMapper;
import io.muenchendigital.digiwf.legacy.dms.muc.external.transport.DMSException;
import io.muenchendigital.digiwf.legacy.dms.muc.external.transport.DMSObjectClass;
import io.muenchendigital.digiwf.legacy.dms.muc.external.transport.DMSSearchResult;
import io.muenchendigital.digiwf.legacy.dms.muc.external.transport.DMSStatusCode;
import io.muenchendigital.digiwf.legacy.dms.muc.properties.DmsProperties;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DmsClient {
    private static final Logger log = LoggerFactory.getLogger(DmsClient.class);
    private final LHMBAI151700GIWSDSoap wsClient;
    private final DMSSearchResultMapper searchResultMapper;
    private final DmsProperties properties;

    public Sachakte createSachakteWithUser(NeueSachakte sachakte, String username) throws DMSException {
        log.info("calling CreateFileGI Userlogin: " + username + " Apentry: " + sachakte.getAktenplanId() + " Filesubj: " + sachakte.getBetreff() + " Shortname: " + sachakte.getKurzname() + " Apentrysearch: true Procedureaccdef: " + sachakte.getZugriffsDefinitionVorgaenge());
        CreateFileGI request = new CreateFileGI();
        request.setUserlogin(username);
        request.setBusinessapp(this.properties.getBusinessapp());
        request.setApentry(sachakte.getAktenplanId());
        request.setFilesubj(sachakte.getBetreff());
        request.setShortname(sachakte.getKurzname());
        request.setApentrysearch(true);
        request.setProcedureaccdef(sachakte.getZugriffsDefinitionVorgaenge());
        CreateFileGIResponse response = this.wsClient.createFileGI(request);
        DMSStatusCode statusCode = DMSStatusCode.byCode((int)response.getStatus());
        if (statusCode != DMSStatusCode.UEBERTRAGUNG_ERFORLGREICH) {
            throw new DMSException(statusCode, response.getErrormessage());
        }
        return new Sachakte(sachakte, response.getObjid());
    }

    public List<DMSSearchResult> searchObjectWithUser(String objectname, DMSObjectClass dmsObjectClass, String username) throws DMSException {
        log.info("calling SearchObjNameGI Userlogin: " + username + " SearchString: " + objectname + " Objclass: " + dmsObjectClass.getName());
        SearchObjNameGI params = new SearchObjNameGI();
        params.setUserlogin(username);
        params.setBusinessapp(this.properties.getBusinessapp());
        params.setObjclass(dmsObjectClass.getName());
        params.setSearchstring(objectname);
        SearchObjNameGIResponse response = this.wsClient.searchObjNameGI(params);
        DMSStatusCode statusCode = DMSStatusCode.byCode((int)response.getStatus());
        if (statusCode != DMSStatusCode.UEBERTRAGUNG_ERFORLGREICH) {
            throw new DMSException(statusCode, response.getErrormessage());
        }
        if (response.getGiobjecttype() == null || response.getGiobjecttype().getLHMBAI151700GIObjectType() == null) {
            log.debug("No search results found");
            return Collections.emptyList();
        }
        return this.searchResultMapper.map2TO(response.getGiobjecttype().getLHMBAI151700GIObjectType());
    }

    public Vorgang createVorgang(NeuerVorgang vorgang, String username) throws DMSException {
        log.info("calling CreateProcedureGI Userlogin: " + username + " Referrednumber: " + vorgang.getSachakteId() + " Shortname: " + vorgang.getKurzname() + " Filesubj: " + vorgang.getBetreff() + " Filetype: " + vorgang.getArt().getValue());
        CreateProcedureGI request = new CreateProcedureGI();
        request.setUserlogin(username);
        request.setReferrednumber(vorgang.getSachakteId());
        request.setBusinessapp(this.properties.getBusinessapp());
        request.setShortname(vorgang.getKurzname());
        request.setFilesubj(vorgang.getBetreff());
        request.setFiletype(vorgang.getArt().getValue());
        CreateProcedureGIResponse response = this.wsClient.createProcedureGI(request);
        DMSStatusCode statusCode = DMSStatusCode.byCode((int)response.getStatus());
        if (statusCode != DMSStatusCode.UEBERTRAGUNG_ERFORLGREICH) {
            throw new DMSException(statusCode, response.getErrormessage());
        }
        return new Vorgang(vorgang, response.getObjid());
    }

    public Dokument createDokument(NeuesDokument dokument, String username) throws DMSException {
        log.info("calling CreateIncomingGI Userlogin: " + username + " Referrednumber: " + dokument.getVorgangId() + " Shortname: " + dokument.getKurzname() + " Filesubj: " + dokument.getBetreff());
        switch (1.$SwitchMap$io$muenchendigital$digiwf$legacy$dms$muc$domain$model$EinAusgehend[dokument.getEinAusgehend().ordinal()]) {
            case 1: {
                return this.createEingehendesDokumentWithUser(dokument, username);
            }
            case 2: {
                return this.createAusgehendesDokumentWithUser(dokument, username);
            }
        }
        throw new AssertionError((Object)"must not happen");
    }

    public String updateSchriftstueck(Schriftstueck schriftstueck, String username) throws DMSException {
        log.info("calling UpdateContentObjectGI Userlogin: " + username + " Objaddress: " + schriftstueck.getCoo());
        UpdateContentObjectGI request = new UpdateContentObjectGI();
        request.setObjaddress(schriftstueck.getCoo());
        request.setUserlogin(username);
        request.setBusinessapp(this.properties.getBusinessapp());
        LHMBAI151700GIAttachmentType attachmentType = this.parseSchriftstueck(schriftstueck);
        request.setGiattachmenttype(attachmentType);
        UpdateContentObjectGIResponse response = this.wsClient.updateContentObjectGI(request);
        DMSStatusCode statusCode = DMSStatusCode.byCode((int)response.getStatus());
        if (statusCode != DMSStatusCode.UEBERTRAGUNG_ERFORLGREICH) {
            throw new DMSException(statusCode, response.getErrormessage());
        }
        return response.getObjid();
    }

    public void cancelDokument(String username, String documentCOO) throws DMSException {
        log.info("calling CancelObjectGI Userlogin: " + username + " Objaddress: " + documentCOO);
        CancelObjectGI cancelObjectGI = new CancelObjectGI();
        cancelObjectGI.setObjaddress(documentCOO);
        cancelObjectGI.setUserlogin(username);
        cancelObjectGI.setBusinessapp(this.properties.getBusinessapp());
        CancelObjectGIResponse response = this.wsClient.cancelObjectGI(cancelObjectGI);
        DMSStatusCode statusCode = DMSStatusCode.byCode((int)response.getStatus());
        if (statusCode != DMSStatusCode.UEBERTRAGUNG_ERFORLGREICH) {
            throw new DMSException(statusCode, response.getErrormessage());
        }
    }

    public void updateEingehendesDokument(Dokument dokument, List<NeuesSchriftstueck> schriftstuecke, String username) throws DMSException {
        log.info("calling UpdateIncomingGI Userlogin: " + username);
        UpdateIncomingGI request = new UpdateIncomingGI();
        request.setUserlogin(username);
        request.setObjaddress(dokument.getCoo());
        request.setShortname(dokument.getKurzname());
        request.setFilesubj(dokument.getBetreff());
        request.setBusinessapp(this.properties.getBusinessapp());
        ArrayOfLHMBAI151700GIAttachmentType attachmentType = new ArrayOfLHMBAI151700GIAttachmentType();
        List files = attachmentType.getLHMBAI151700GIAttachmentType();
        for (NeuesSchriftstueck schriftstueck : schriftstuecke) {
            files.add(this.parseSchriftstueck(schriftstueck));
        }
        request.setGiattachmenttype(attachmentType);
        UpdateIncomingGIResponse response = this.wsClient.updateIncomingGI(request);
        DMSStatusCode statusCode = DMSStatusCode.byCode((int)response.getStatus());
        if (statusCode != DMSStatusCode.UEBERTRAGUNG_ERFORLGREICH) {
            throw new DMSException(statusCode, response.getErrormessage());
        }
    }

    public Metadata readContentMetadata(String coo, String username) {
        log.info("calling ReadContentObjectMetaDataGI Userlogin: " + username + " COO: " + coo);
        ReadContentObjectMetaDataGI request = new ReadContentObjectMetaDataGI();
        request.setObjaddress(coo);
        request.setBusinessapp(this.properties.getBusinessapp());
        request.setUserlogin(username);
        ReadContentObjectMetaDataGIResponse response = this.wsClient.readContentObjectMetaDataGI(request);
        return Metadata.builder().url(String.format(this.properties.getUiurl(), coo)).name(response.getGimetadatatype().getLHMBAI151700Filename()).type(response.getGimetadatatype().getLHMBAI151700Objclass()).build();
    }

    public void depositVorgang(String vorgangCoo, String username) throws DMSException {
        log.info("calling DepositObjectGI Userlogin: " + username + " Objaddress: " + vorgangCoo);
        DepositObjectGI depositObjectGI = new DepositObjectGI();
        depositObjectGI.setObjaddress(vorgangCoo);
        depositObjectGI.setBusinessapp(this.properties.getBusinessapp());
        depositObjectGI.setUserlogin(username);
        DepositObjectGIResponse response = this.wsClient.depositObjectGI(depositObjectGI);
        DMSStatusCode statusCode = DMSStatusCode.byCode((int)response.getStatus());
        if (statusCode != DMSStatusCode.UEBERTRAGUNG_ERFORLGREICH) {
            throw new DMSException(statusCode, response.getErrormessage());
        }
    }

    public Schriftstueck readSchriftstueck(String username, String coo) throws DMSException, IOException {
        log.info("calling DepositObjectGI Userlogin: " + username + " Objaddress: " + coo);
        ReadContentObjectGI request = new ReadContentObjectGI();
        request.setObjaddress(coo);
        request.setBusinessapp(this.properties.getBusinessapp());
        request.setUserlogin(username);
        ReadContentObjectGIResponse response = this.wsClient.readContentObjectGI(request);
        DMSStatusCode statusCode = DMSStatusCode.byCode((int)response.getStatus());
        if (statusCode != DMSStatusCode.UEBERTRAGUNG_ERFORLGREICH) {
            throw new DMSException(statusCode, response.getErrormessage());
        }
        return Schriftstueck.builder().coo(coo).name(response.getGiattachmenttype().getLHMBAI151700Filename()).extension(response.getGiattachmenttype().getLHMBAI151700Fileextension()).content(IOUtils.toByteArray((InputStream)response.getGiattachmenttype().getLHMBAI151700Filecontent().getInputStream())).build();
    }

    private LHMBAI151700GIAttachmentType parseSchriftstueck(NeuesSchriftstueck schriftstueck) {
        LHMBAI151700GIAttachmentType attachment = new LHMBAI151700GIAttachmentType();
        DataHandler dataHandler = new DataHandler((DataSource)new ByteArrayDataSource(schriftstueck.getContent(), schriftstueck.getExtension()));
        attachment.setLHMBAI151700Filecontent(dataHandler);
        attachment.setLHMBAI151700Fileextension(schriftstueck.getExtension());
        attachment.setLHMBAI151700Filename(schriftstueck.getName());
        return attachment;
    }

    private LHMBAI151700GIAttachmentType parseSchriftstueck(Schriftstueck schriftstueck) {
        LHMBAI151700GIAttachmentType attachment = new LHMBAI151700GIAttachmentType();
        DataHandler dataHandler = new DataHandler((DataSource)new ByteArrayDataSource(schriftstueck.getContent(), schriftstueck.getExtension()));
        attachment.setLHMBAI151700Filecontent(dataHandler);
        attachment.setLHMBAI151700Fileextension(schriftstueck.getExtension());
        attachment.setLHMBAI151700Filename(schriftstueck.getName());
        return attachment;
    }

    private Dokument createEingehendesDokumentWithUser(NeuesDokument dokument, String username) throws DMSException {
        CreateIncomingGI request = new CreateIncomingGI();
        request.setUserlogin(username);
        request.setReferrednumber(dokument.getVorgangId());
        request.setBusinessapp(this.properties.getBusinessapp());
        request.setShortname(dokument.getKurzname());
        request.setFilesubj(dokument.getBetreff());
        ArrayOfLHMBAI151700GIAttachmentType attachmentType = new ArrayOfLHMBAI151700GIAttachmentType();
        List files = attachmentType.getLHMBAI151700GIAttachmentType();
        for (NeuesSchriftstueck schriftstueck : dokument.getSchriftstuecke()) {
            files.add(this.parseSchriftstueck(schriftstueck));
        }
        request.setGiattachmenttype(attachmentType);
        CreateIncomingGIResponse response = this.wsClient.createIncomingGI(request);
        DMSStatusCode statusCode = DMSStatusCode.byCode((int)response.getStatus());
        if (statusCode != DMSStatusCode.UEBERTRAGUNG_ERFORLGREICH) {
            throw new DMSException(statusCode, response.getErrormessage());
        }
        List schriftstuecke = this.checkSchriftstuecke(response.getObjid(), username, dokument.getSchriftstuecke());
        return new Dokument(dokument, response.getObjid(), schriftstuecke);
    }

    private List<Schriftstueck> checkSchriftstuecke(String documentCoo, String username, List<NeuesSchriftstueck> schriftstuecke) throws DMSException {
        if (schriftstuecke.size() == 0) {
            return Collections.emptyList();
        }
        ReadDocumentGIObjects readRequest = new ReadDocumentGIObjects();
        readRequest.setObjaddress(documentCoo);
        readRequest.setBusinessapp(this.properties.getBusinessapp());
        readRequest.setUserlogin(username);
        ReadDocumentGIObjectsResponse readResponse = this.wsClient.readDocumentGIObjects(readRequest);
        List geladeneSchriftstuecke = readResponse.getGiobjecttype().getLHMBAI151700GIObjectType();
        if (geladeneSchriftstuecke.size() != schriftstuecke.size()) {
            String message = String.format("dms hat nicht die richtige anzahl an schriftst\u00fccken erstellt (erwartet: %s, ist: %d)", geladeneSchriftstuecke.size(), schriftstuecke.size());
            throw new DMSException(message);
        }
        ArrayList<Schriftstueck> erstellteSchriftstuecke = new ArrayList<Schriftstueck>();
        for (int i = 0; i < schriftstuecke.size(); ++i) {
            NeuesSchriftstueck schriftstueck = schriftstuecke.get(i);
            LHMBAI151700GIObjectType erstelltesSchriftstueck = (LHMBAI151700GIObjectType)geladeneSchriftstuecke.get(i);
            if (!schriftstueck.getName().equals(erstelltesSchriftstueck.getLHMBAI151700Objname())) {
                throw new DMSException("Reihenfolge der gelesenen IDs stimmt nicht mit der hochgeladenen \u00fcberein. Kommentar dazu im Code lesen");
            }
            erstellteSchriftstuecke.add(new Schriftstueck(schriftstueck, erstelltesSchriftstueck.getLHMBAI151700Objaddress()));
        }
        return erstellteSchriftstuecke;
    }

    private Dokument createAusgehendesDokumentWithUser(NeuesDokument dokument, String username) throws DMSException {
        CreateOutgoingGI request = new CreateOutgoingGI();
        request.setUserlogin(username);
        request.setReferrednumber(dokument.getVorgangId());
        request.setBusinessapp(this.properties.getBusinessapp());
        request.setShortname(dokument.getKurzname());
        request.setFilesubj(dokument.getBetreff());
        ArrayOfLHMBAI151700GIAttachmentType attachmentType = new ArrayOfLHMBAI151700GIAttachmentType();
        List files = attachmentType.getLHMBAI151700GIAttachmentType();
        for (NeuesSchriftstueck schriftstueck : dokument.getSchriftstuecke()) {
            files.add(this.parseSchriftstueck(schriftstueck));
        }
        request.setGiattachmenttype(attachmentType);
        request.setSubfiletype("BeZweck-Ausgang");
        CreateOutgoingGIResponse response = this.wsClient.createOutgoingGI(request);
        DMSStatusCode statusCode = DMSStatusCode.byCode((int)response.getStatus());
        if (statusCode != DMSStatusCode.UEBERTRAGUNG_ERFORLGREICH) {
            throw new DMSException(statusCode, response.getErrormessage());
        }
        List schriftstuecke = this.checkSchriftstuecke(response.getObjid(), username, dokument.getSchriftstuecke());
        return new Dokument(dokument, response.getObjid(), schriftstuecke);
    }

    public List<Schriftstueck> getAllSchriftstuecke(String documentCoo, String username) throws DMSException {
        ReadDocumentGIObjects readRequest = new ReadDocumentGIObjects();
        readRequest.setObjaddress(documentCoo);
        readRequest.setUserlogin(username);
        readRequest.setBusinessapp(this.properties.getBusinessapp());
        ReadDocumentGIObjectsResponse readResponse = this.wsClient.readDocumentGIObjects(readRequest);
        if (readResponse.getGiobjecttype() == null) {
            return new ArrayList<Schriftstueck>();
        }
        return readResponse.getGiobjecttype().getLHMBAI151700GIObjectType().stream().map(obj -> Schriftstueck.builder().coo(obj.getLHMBAI151700Objaddress()).name(obj.getLHMBAI151700Objname()).build()).collect(Collectors.toList());
    }

    public DmsClient(LHMBAI151700GIWSDSoap wsClient, DMSSearchResultMapper searchResultMapper, DmsProperties properties) {
        this.wsClient = wsClient;
        this.searchResultMapper = searchResultMapper;
        this.properties = properties;
    }
}

