/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.legacy.dms.muc.process.canceldokument;

import io.holunda.camunda.bpm.data.CamundaBpmData;
import io.holunda.camunda.bpm.data.factory.VariableFactory;
import io.muenchendigital.digiwf.legacy.dms.muc.domain.service.DmsService;
import io.muenchendigital.digiwf.legacy.dms.muc.external.transport.DMSException;
import io.muenchendigital.digiwf.legacy.dms.muc.external.transport.DMSStatusCode;
import org.apache.commons.lang3.StringUtils;
import org.camunda.bpm.engine.delegate.BpmnError;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CancelDokumentDelegate
implements JavaDelegate {
    private static final Logger log = LoggerFactory.getLogger(CancelDokumentDelegate.class);
    public static final String ERROR_CANCELATION_FAILED = "LOESCHUNG_FEHLGESCHLAGEN";
    private final DmsService dmsService;
    public static final VariableFactory<String> DOCUMENT_COO = CamundaBpmData.stringVariable((String)"dms_document_coo");
    public static final VariableFactory<String> DMS_USER = CamundaBpmData.stringVariable((String)"dms_user_login");

    public void execute(DelegateExecution execution) throws Exception {
        String documentCoo = (String)DOCUMENT_COO.from((VariableScope)execution).getLocal();
        String userLogin = (String)DMS_USER.from((VariableScope)execution).getLocal();
        log.debug(String.format("Cancel Document %s with user %s", documentCoo, userLogin));
        if (StringUtils.isBlank((CharSequence)documentCoo)) {
            return;
        }
        try {
            this.dmsService.cancelDocument(userLogin, documentCoo);
        }
        catch (Exception error) {
            DMSException dmsException;
            log.error("Could not cancel documents: {}", (Object)error.getMessage());
            if (error instanceof DMSException && (dmsException = (DMSException)((Object)error)).getStatusCode() == DMSStatusCode.OBJEKT_GESPERRT) {
                throw new BpmnError(dmsException.getStatusCode().name(), dmsException.getMessage());
            }
            throw new BpmnError(ERROR_CANCELATION_FAILED);
        }
    }

    public CancelDokumentDelegate(DmsService dmsService) {
        this.dmsService = dmsService;
    }
}

