/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.legacy.dms.muc.process.createvorgang;

import io.holunda.camunda.bpm.data.CamundaBpmData;
import io.holunda.camunda.bpm.data.factory.VariableFactory;
import io.muenchendigital.digiwf.legacy.dms.muc.domain.model.Vorgang;
import io.muenchendigital.digiwf.legacy.dms.muc.domain.service.DmsService;
import io.muenchendigital.digiwf.legacy.dms.muc.external.transport.DMSException;
import io.muenchendigital.digiwf.legacy.dms.muc.external.transport.DMSStatusCode;
import org.camunda.bpm.engine.delegate.BpmnError;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CreateVorgangDelegate
implements JavaDelegate {
    private static final Logger log = LoggerFactory.getLogger(CreateVorgangDelegate.class);
    private final DmsService dmsService;
    public static final VariableFactory<String> VORGANG_TITLE = CamundaBpmData.stringVariable((String)"dms_vorgang_title");
    public static final VariableFactory<String> SACHATKE_COO = CamundaBpmData.stringVariable((String)"dms_sachakte_coo");
    public static final VariableFactory<String> USER_LOGIN = CamundaBpmData.stringVariable((String)"dms_user_login");
    public static final VariableFactory<String> VORGANG_COO = CamundaBpmData.stringVariable((String)"dms_vorgang_coo");

    public void execute(DelegateExecution execution) throws Exception {
        String vorgangTitel = (String)VORGANG_TITLE.from((VariableScope)execution).getLocal();
        String sachakteCOO = (String)SACHATKE_COO.from((VariableScope)execution).getLocal();
        String userLogin = (String)USER_LOGIN.from((VariableScope)execution).getLocal();
        try {
            Vorgang vorgang = this.dmsService.createVorgang(vorgangTitel, sachakteCOO, userLogin);
            VORGANG_COO.on((VariableScope)execution).setLocal((Object)vorgang.getCoo());
        }
        catch (DMSException ex) {
            log.error("Could not create vorgang: {}", (Object)ex.getMessage());
            if (DMSStatusCode.OBJEKT_GESPERRT.equals((Object)ex.getStatusCode()) || DMSStatusCode.FEHLENDE_BERECHTIGUNG.equals((Object)ex.getStatusCode()) || DMSStatusCode.MEHR_ALS_1000_UNTERGEORDNETE_OBJEKTE.equals((Object)ex.getStatusCode())) {
                throw new BpmnError(ex.getStatusCode().name(), ex.getMessage());
            }
            throw ex;
        }
    }

    public CreateVorgangDelegate(DmsService dmsService) {
        this.dmsService = dmsService;
    }
}

