/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.legacy.dms.muc.process.readschriftstueck;

import com.google.gson.Gson;
import io.holunda.camunda.bpm.data.CamundaBpmData;
import io.holunda.camunda.bpm.data.factory.VariableFactory;
import io.muenchendigital.digiwf.legacy.dms.muc.domain.model.Metadata;
import io.muenchendigital.digiwf.legacy.dms.muc.domain.model.Schriftstueck;
import io.muenchendigital.digiwf.legacy.dms.muc.domain.service.DmsService;
import io.muenchendigital.digiwf.legacy.dms.muc.process.readschriftstueck.ReadSchriftstueckeData;
import io.muenchendigital.digiwf.legacy.dms.muc.process.readschriftstueck.ReadSchriftstueckeResult;
import io.muenchendigital.digiwf.legacy.dms.shared.BaseSchriftstueck;
import io.muenchendigital.digiwf.legacy.dms.shared.BaseSchriftstueckeData;
import java.util.ArrayList;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.client.HttpClientErrorException;

@Component
public class ReadSchriftstueckeDelegate
implements JavaDelegate {
    private static final Logger log = LoggerFactory.getLogger(ReadSchriftstueckeDelegate.class);
    private final DmsService dmsService;
    public static final VariableFactory<String> SCHRIFTSTUECKE = CamundaBpmData.stringVariable((String)"dms_schriftstuecke");
    public static final VariableFactory<String> USER_LOGIN = CamundaBpmData.stringVariable((String)"dms_user_login");
    public static final VariableFactory<BaseSchriftstueckeData[]> READ_SCHRIFTSTUECKE_RESULT = CamundaBpmData.customVariable((String)"dms_read_schriftstuecke_result", BaseSchriftstueckeData[].class);

    public void execute(DelegateExecution execution) throws Exception {
        ReadSchriftstueckeData[] data = (ReadSchriftstueckeData[])new Gson().fromJson((String)SCHRIFTSTUECKE.from((VariableScope)execution).getLocal(), ReadSchriftstueckeData[].class);
        String user = (String)USER_LOGIN.from((VariableScope)execution).getLocal();
        ArrayList<ReadSchriftstueckeResult> resultData = new ArrayList<ReadSchriftstueckeResult>();
        for (ReadSchriftstueckeData readData : data) {
            ArrayList<Schriftstueck> resultList = new ArrayList<Schriftstueck>();
            for (Metadata schriftstueck : readData.getSchriftstuecke()) {
                try {
                    Schriftstueck schriftstueckModel = this.dmsService.readSchriftstueck(user, schriftstueck.getUrl());
                    resultList.add(schriftstueckModel);
                }
                catch (HttpClientErrorException error) {
                    log.error("Document could not be read from dms kvr: " + schriftstueck.getUrl(), (Throwable)error);
                    throw error;
                }
            }
            resultData.add(new ReadSchriftstueckeResult(readData.getFieldKey(), (BaseSchriftstueck[])resultList.toArray(new Schriftstueck[0])));
        }
        READ_SCHRIFTSTUECKE_RESULT.on((VariableScope)execution).set((Object)((BaseSchriftstueckeData[])resultData.toArray(new ReadSchriftstueckeResult[0])), true);
    }

    public ReadSchriftstueckeDelegate(DmsService dmsService) {
        this.dmsService = dmsService;
    }
}

