/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.legacy.dms.muc.process.saveschriftstuecke;

import io.holunda.camunda.bpm.data.CamundaBpmData;
import io.holunda.camunda.bpm.data.factory.VariableFactory;
import io.muenchendigital.digiwf.legacy.dms.muc.domain.model.Dokument;
import io.muenchendigital.digiwf.legacy.dms.muc.domain.model.Metadata;
import io.muenchendigital.digiwf.legacy.dms.muc.domain.model.NeuesSchriftstueck;
import io.muenchendigital.digiwf.legacy.dms.muc.domain.model.Schriftstueck;
import io.muenchendigital.digiwf.legacy.dms.muc.domain.service.DmsService;
import io.muenchendigital.digiwf.legacy.dms.muc.external.transport.DMSException;
import io.muenchendigital.digiwf.legacy.dms.muc.external.transport.DMSStatusCode;
import io.muenchendigital.digiwf.legacy.dms.muc.process.saveschriftstuecke.SaveSchriftstueckeResult;
import io.muenchendigital.digiwf.legacy.dms.shared.BaseSchriftstueck;
import io.muenchendigital.digiwf.legacy.dms.shared.BaseSchriftstueckeData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.camunda.bpm.engine.delegate.BpmnError;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Deprecated
@Component
public class SaveSchriftstueckeDelegate
implements JavaDelegate {
    private static final Logger log = LoggerFactory.getLogger(SaveSchriftstueckeDelegate.class);
    private final DmsService dmsService;
    public static final VariableFactory<String> USER_LOGIN = CamundaBpmData.stringVariable((String)"dms_user_login");
    public static final VariableFactory<String> DOCUMENT_NAME = CamundaBpmData.stringVariable((String)"dms_document_name");
    public static final VariableFactory<String> VORGANG_COO = CamundaBpmData.stringVariable((String)"dms_vorgang_coo");
    public static final VariableFactory<BaseSchriftstueckeData[]> SCHRIFTSTUECKE = CamundaBpmData.customVariable((String)"dms_read_schriftstuecke_result", BaseSchriftstueckeData[].class);
    public static final VariableFactory<String> DOCUMENT_COO = CamundaBpmData.stringVariable((String)"dms_document_coo");
    public static final VariableFactory<SaveSchriftstueckeResult[]> SAVE_SCHRIFTSTUECKE_RESULT = CamundaBpmData.customVariable((String)"dms_save_schriftstuecke_result", SaveSchriftstueckeResult[].class);

    public void execute(DelegateExecution execution) throws Exception {
        BaseSchriftstueckeData[] data = (BaseSchriftstueckeData[])SCHRIFTSTUECKE.from((VariableScope)execution).get();
        String user = (String)USER_LOGIN.from((VariableScope)execution).getLocal();
        String documentName = (String)DOCUMENT_NAME.from((VariableScope)execution).getLocal();
        String vorgangCOO = (String)VORGANG_COO.from((VariableScope)execution).getLocal();
        ArrayList<SaveSchriftstueckeResult> resultData = new ArrayList<SaveSchriftstueckeResult>();
        try {
            List alleSchriftstuecke = Arrays.stream(data).map(BaseSchriftstueckeData::getSchriftstuecke).flatMap(Stream::of).map(arg_0 -> this.parse(arg_0)).collect(Collectors.toList());
            Dokument document = this.dmsService.createDokument(documentName, vorgangCOO, user, alleSchriftstuecke);
            int counter = 0;
            for (BaseSchriftstueckeData schriftstueckeData : data) {
                SaveSchriftstueckeResult result = SaveSchriftstueckeResult.builder().fieldKey(schriftstueckeData.getFieldKey()).schriftstuecke(this.map(document, Arrays.asList(schriftstueckeData.getSchriftstuecke()), user, counter)).build();
                counter += result.getSchriftstuecke().size();
                resultData.add(result);
            }
            DOCUMENT_COO.on((VariableScope)execution).setLocal((Object)document.getCoo());
            SAVE_SCHRIFTSTUECKE_RESULT.on((VariableScope)execution).setLocal((Object)resultData.toArray(new SaveSchriftstueckeResult[0]));
        }
        catch (DMSException exception) {
            if (exception.getStatusCode() == DMSStatusCode.OBJEKT_GESPERRT) {
                throw new BpmnError(exception.getStatusCode().name(), exception.getMessage());
            }
            throw exception;
        }
        catch (Exception exception) {
            log.error("An error occurred while saving documents to the target DMS: {}", (Object)exception.toString());
            throw exception;
        }
    }

    private NeuesSchriftstueck parse(BaseSchriftstueck schriftstueck) {
        return NeuesSchriftstueck.builder().content(schriftstueck.getContent()).extension(schriftstueck.getExtension()).name(schriftstueck.getName()).build();
    }

    private List<Metadata> map(Dokument document, List<BaseSchriftstueck> baseSchriftstuecke, String userlogin, int counter) {
        ArrayList<Schriftstueck> schriftstuecke = new ArrayList<Schriftstueck>();
        for (int i = 0; i < baseSchriftstuecke.size(); ++i) {
            Schriftstueck doc = (Schriftstueck)document.getSchriftstuecke().get(counter + i);
            schriftstuecke.add(doc);
        }
        return this.dmsService.getMetadata(schriftstuecke, userlogin);
    }

    public SaveSchriftstueckeDelegate(DmsService dmsService) {
        this.dmsService = dmsService;
    }
}

