/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.legacy.dms.muc.process.searchsachakte;

import io.holunda.camunda.bpm.data.CamundaBpmData;
import io.holunda.camunda.bpm.data.factory.VariableFactory;
import io.muenchendigital.digiwf.legacy.dms.muc.domain.service.DmsService;
import io.muenchendigital.digiwf.legacy.dms.muc.external.transport.DMSException;
import io.muenchendigital.digiwf.legacy.dms.muc.external.transport.DMSStatusCode;
import java.util.Optional;
import org.camunda.bpm.engine.delegate.BpmnError;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SearchSachakteDelegate
implements JavaDelegate {
    private static final Logger log = LoggerFactory.getLogger(SearchSachakteDelegate.class);
    private final DmsService dmsService;
    public static final VariableFactory<String> UNTERGRUPPE = CamundaBpmData.stringVariable((String)"dms_untergruppe");
    public static final VariableFactory<String> SACHAKTE_NAME = CamundaBpmData.stringVariable((String)"dms_sachakte_name");
    public static final VariableFactory<String> USER_LOGIN = CamundaBpmData.stringVariable((String)"dms_user_login");
    public static final VariableFactory<String> SACHAKTE_COO = CamundaBpmData.stringVariable((String)"dms_sachakte_coo");

    public void execute(DelegateExecution execution) throws Exception {
        String untergruppe = (String)UNTERGRUPPE.from((VariableScope)execution).getLocal();
        String sachakte = (String)SACHAKTE_NAME.from((VariableScope)execution).getLocal();
        String userlogin = (String)USER_LOGIN.from((VariableScope)execution).getLocal();
        String searchString = untergruppe + ".*-" + sachakte + "-*";
        try {
            Optional sachakteCoo = this.dmsService.searchSachakte(searchString, userlogin);
            sachakteCoo.ifPresent(s -> SACHAKTE_COO.on((VariableScope)execution).setLocal(s));
        }
        catch (DMSException ex) {
            log.error("Could not search for sachakte: {}", (Object)ex.getMessage());
            if (DMSStatusCode.FEHLENDE_BERECHTIGUNG.equals((Object)ex.getStatusCode())) {
                throw new BpmnError(ex.getStatusCode().name(), ex.getMessage());
            }
            throw ex;
        }
    }

    public SearchSachakteDelegate(DmsService dmsService) {
        this.dmsService = dmsService;
    }
}

