/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.legacy.document.api.resource;

import io.muenchendigital.digiwf.legacy.document.api.transport.StatusDokumentTO;
import io.muenchendigital.digiwf.legacy.document.domain.DocumentService;
import io.muenchendigital.digiwf.shared.security.AppAuthenticationProvider;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@Transactional
@RequestMapping(value={"/rest/document"})
@Tag(name="DocumentRestController", description="API to interact with documents")
public class DocumentRestController {
    private final DocumentService documentService;
    private final AppAuthenticationProvider authenticationProvider;

    @GetMapping(value={"/task/{id}"})
    public ResponseEntity<StatusDokumentTO> getStatusDokumentForTask(@PathVariable(value="id") String taskId) {
        String userLogin = this.authenticationProvider.getCurrentUserId();
        byte[] data = this.documentService.getStatusDokumentForTask(taskId, userLogin);
        return ResponseEntity.ok((Object)StatusDokumentTO.builder().data(data).build());
    }

    public DocumentRestController(DocumentService documentService, AppAuthenticationProvider authenticationProvider) {
        this.documentService = documentService;
        this.authenticationProvider = authenticationProvider;
    }
}

