/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.legacy.document.domain;

import io.muenchendigital.digiwf.humantask.domain.service.HumanTaskService;
import io.muenchendigital.digiwf.legacy.document.external.client.CosysClient;
import io.muenchendigital.digiwf.process.config.domain.model.ProcessConfig;
import io.muenchendigital.digiwf.process.config.domain.service.ProcessConfigService;
import io.muenchendigital.digiwf.process.definition.domain.service.ServiceDefinitionService;
import io.muenchendigital.digiwf.shared.exception.ObjectNotFoundException;
import io.muenchendigital.digiwf.task.TaskVariables;
import java.util.Map;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.task.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DocumentService {
    private static final Logger log = LoggerFactory.getLogger(DocumentService.class);
    private final CosysClient cosysClient;
    private final ServiceDefinitionService processDefinitionService;
    private final HumanTaskService taskService;
    private final TaskService camundaTaskService;
    private final ProcessConfigService processConfigService;
    private final RuntimeService runtimeService;

    public byte[] createDocument(String documentGuid, Map<String, Object> variables) {
        return this.cosysClient.generateDocument(documentGuid, variables);
    }

    public byte[] createDocument(String documentGuid, String executionId) {
        return this.cosysClient.generateDocument(documentGuid, this.runtimeService.getVariables(executionId));
    }

    public byte[] getStatusDokumentForTask(String taskId, String userId) {
        Task task = this.taskService.getTask(taskId);
        String assignedUserId = (String)TaskVariables.TASK_ASSIGNEE.from(this.camundaTaskService, taskId).getLocal();
        if (!userId.equals(assignedUserId)) {
            throw new ObjectNotFoundException(String.format("The task with the id %s is not available.", taskId));
        }
        ProcessDefinition processDefinition = this.processDefinitionService.getServiceDefinition(task.getProcessDefinitionId());
        String statusDokument = ((ProcessConfig)this.processConfigService.getProcessConfig(processDefinition.getKey()).orElseThrow(() -> new ObjectNotFoundException("No Status document available"))).getStatusDokument();
        return this.createDocument(statusDokument, this.runtimeService.getVariables(task.getProcessInstanceId()));
    }

    public DocumentService(CosysClient cosysClient, ServiceDefinitionService processDefinitionService, HumanTaskService taskService, TaskService camundaTaskService, ProcessConfigService processConfigService, RuntimeService runtimeService) {
        this.cosysClient = cosysClient;
        this.processDefinitionService = processDefinitionService;
        this.taskService = taskService;
        this.camundaTaskService = camundaTaskService;
        this.processConfigService = processConfigService;
        this.runtimeService = runtimeService;
    }
}

