/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.legacy.document.external.client;

import io.muenchendigital.digiwf.legacy.document.external.model.GenerateDocumentTO;
import io.muenchendigital.digiwf.legacy.document.external.properties.CosysProperties;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class CosysClient {
    private static final Logger log = LoggerFactory.getLogger(CosysClient.class);
    private final CosysProperties properties;
    private final RestTemplate restTemplate = new RestTemplate();

    public byte[] generateDocument(String guid, Map<String, Object> variables) {
        String restCallFullUrl = this.properties.getAddress() + "camel/generation/pdf/";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_OCTET_STREAM));
        GenerateDocumentTO model = GenerateDocumentTO.builder().guid(guid).variables(this.parseVariables(variables)).build();
        HttpEntity entity = new HttpEntity((Object)model, (MultiValueMap)headers);
        log.info("calling generateDocument: {}", (Object)guid);
        return (byte[])this.restTemplate.postForObject(restCallFullUrl, (Object)entity, byte[].class, new Object[0]);
    }

    private Map<String, String> parseVariables(Map<String, Object> variables) {
        return variables.entrySet().stream().filter(entry -> entry.getValue() != null).collect(HashMap::new, (m, v) -> m.put((String)v.getKey(), v.getValue().toString()), HashMap::putAll);
    }

    public CosysClient(CosysProperties properties) {
        this.properties = properties;
    }
}

