/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.legacy.form.domain.model;

import io.muenchendigital.digiwf.legacy.form.domain.model.Buttons;
import io.muenchendigital.digiwf.legacy.form.domain.model.Form;
import io.muenchendigital.digiwf.legacy.form.domain.model.FormField;
import io.muenchendigital.digiwf.legacy.form.domain.model.Group;
import io.muenchendigital.digiwf.legacy.form.domain.validator.ValidationHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import org.apache.commons.lang3.StringUtils;

public class Form {
    @NotBlank
    private final String key;
    private final String description;
    private final String authorizedGroups;
    private final Buttons buttons;
    @Size(min=1, max=100)
    private final @Size(min=1, max=100) List<Group> groups;

    public List<String> getFormFieldKeys() {
        return this.groups.stream().map(Group::getFormFieldKeys).flatMap(Collection::stream).filter(key -> !StringUtils.isBlank((CharSequence)key)).collect(Collectors.toList());
    }

    private List<FormField> getFormFields() {
        return this.groups.stream().map(Group::getSchema).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public boolean validateVariables(Map<String, Object> variables, List<ValidationHandler> validationHandlers) {
        List formFields = this.getFormFieldKeys();
        if (!formFields.containsAll(variables.keySet())) {
            return false;
        }
        return this.getFormFields().stream().allMatch(obj -> obj.validate(variables.get(obj.getKey()), validationHandlers));
    }

    public Optional<FormField> getFormField(String key) {
        return this.groups.stream().map(Group::getSchema).flatMap(Collection::stream).filter(field -> key.equals(field.getKey())).findFirst();
    }

    public Map<String, FormField> getFormFieldMap() {
        return this.groups.stream().map(Group::getSchema).flatMap(Collection::stream).filter(field -> !StringUtils.isBlank((CharSequence)field.getKey())).collect(Collectors.toMap(FormField::getKey, f -> f));
    }

    private static List<Group> $default$groups() {
        return new ArrayList<Group>();
    }

    public static FormBuilder builder() {
        return new FormBuilder();
    }

    public String getKey() {
        return this.key;
    }

    public String getDescription() {
        return this.description;
    }

    public String getAuthorizedGroups() {
        return this.authorizedGroups;
    }

    public Buttons getButtons() {
        return this.buttons;
    }

    public List<Group> getGroups() {
        return this.groups;
    }

    public String toString() {
        return "Form(key=" + this.getKey() + ", description=" + this.getDescription() + ", authorizedGroups=" + this.getAuthorizedGroups() + ", buttons=" + this.getButtons() + ", groups=" + this.getGroups() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Form)) {
            return false;
        }
        Form other = (Form)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$authorizedGroups = this.getAuthorizedGroups();
        String other$authorizedGroups = other.getAuthorizedGroups();
        if (this$authorizedGroups == null ? other$authorizedGroups != null : !this$authorizedGroups.equals(other$authorizedGroups)) {
            return false;
        }
        Buttons this$buttons = this.getButtons();
        Buttons other$buttons = other.getButtons();
        if (this$buttons == null ? other$buttons != null : !this$buttons.equals(other$buttons)) {
            return false;
        }
        List this$groups = this.getGroups();
        List other$groups = other.getGroups();
        return !(this$groups == null ? other$groups != null : !((Object)this$groups).equals(other$groups));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Form;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $authorizedGroups = this.getAuthorizedGroups();
        result = result * 59 + ($authorizedGroups == null ? 43 : $authorizedGroups.hashCode());
        Buttons $buttons = this.getButtons();
        result = result * 59 + ($buttons == null ? 43 : $buttons.hashCode());
        List $groups = this.getGroups();
        result = result * 59 + ($groups == null ? 43 : ((Object)$groups).hashCode());
        return result;
    }

    public Form(String key, String description, String authorizedGroups, Buttons buttons, List<Group> groups) {
        this.key = key;
        this.description = description;
        this.authorizedGroups = authorizedGroups;
        this.buttons = buttons;
        this.groups = groups;
    }
}

