/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.legacy.form.domain.service;

import io.muenchendigital.digiwf.legacy.form.domain.mapper.FormMapper;
import io.muenchendigital.digiwf.legacy.form.domain.model.Form;
import io.muenchendigital.digiwf.legacy.form.domain.service.InAuthorizedGroupsPredicate;
import io.muenchendigital.digiwf.legacy.form.domain.validator.ValidationHandler;
import io.muenchendigital.digiwf.legacy.form.infrastructure.entity.FormEntity;
import io.muenchendigital.digiwf.legacy.form.infrastructure.repository.FormRepository;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Service;

@Deprecated
@Service(value="digitalWfFormService")
public class FormService {
    private static final Logger log = LoggerFactory.getLogger(FormService.class);
    private final FormMapper formMapper;
    private final FormRepository formRepository;
    private final List<ValidationHandler> validationHandlers;
    private final InAuthorizedGroupsPredicate inAuthorizedGroupsPredicate;

    public List<Form> getForms() {
        List formEntities = this.formRepository.findAll();
        List filteredEntities = formEntities.stream().filter(this.inAuthorizedGroupsPredicate).collect(Collectors.toList());
        return this.formMapper.map(filteredEntities);
    }

    public Optional<Form> getForm(String formkey) {
        return this.formRepository.findByKey(formkey).map(arg_0 -> ((FormMapper)this.formMapper).map(arg_0));
    }

    public Form saveForm(Form form) {
        Optional entity = this.formRepository.findByKey(form.getKey());
        FormEntity newEntity = this.formMapper.map2Entity(form);
        if (entity.isPresent()) {
            FormEntity formEntity = (FormEntity)entity.get();
            if (!this.inAuthorizedGroupsPredicate.test(formEntity)) {
                throw new AccessDeniedException(form.getKey());
            }
            newEntity.setId(formEntity.getId());
        }
        FormEntity savedEntity = (FormEntity)this.formRepository.save((Object)newEntity);
        log.info("Form deployed: {}", (Object)savedEntity);
        return this.formMapper.map(savedEntity);
    }

    public Optional<Form> getStartForm(String formKey) {
        return this.getForm(formKey);
    }

    public boolean validateVariables(String formKey, Map<String, Object> variables) {
        Form form = (Form)this.getForm(formKey).get();
        return form.validateVariables(variables, this.validationHandlers);
    }

    public FormService(FormMapper formMapper, FormRepository formRepository, List<ValidationHandler> validationHandlers, InAuthorizedGroupsPredicate inAuthorizedGroupsPredicate) {
        this.formMapper = formMapper;
        this.formRepository = formRepository;
        this.validationHandlers = validationHandlers;
        this.inAuthorizedGroupsPredicate = inAuthorizedGroupsPredicate;
    }
}

