/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.legacy.form.domain.service;

import io.muenchendigital.digiwf.legacy.form.infrastructure.entity.FormEntity;
import io.muenchendigital.digiwf.legacy.user.domain.model.User;
import io.muenchendigital.digiwf.legacy.user.domain.service.UserService;
import io.muenchendigital.digiwf.shared.security.UserAuthenticationProvider;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class InAuthorizedGroupsPredicate
implements Predicate<FormEntity> {
    private final UserAuthenticationProvider userProvider;
    private final UserService userService;

    @Override
    public boolean test(FormEntity form) {
        if (StringUtils.isEmpty((CharSequence)form.getAuthorization())) {
            return true;
        }
        String username = this.userProvider.getLoggedInUser();
        Optional user = this.userService.getUserByUserName(username);
        if (user.isPresent()) {
            List userGroups = this.userService.getGroups(((User)user.get()).getLhmObjectId());
            List<String> authorizedGroups = Arrays.asList(form.getAuthorization().split(","));
            for (String grp : userGroups) {
                if (!authorizedGroups.contains(grp)) continue;
                return true;
            }
        }
        return false;
    }

    public InAuthorizedGroupsPredicate(UserAuthenticationProvider userProvider, UserService userService) {
        this.userProvider = userProvider;
        this.userService = userService;
    }
}

