/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.legacy.mailing.domain.configuration;

import java.util.Map;
import java.util.Properties;
import javax.mail.MessagingException;
import org.springframework.boot.autoconfigure.mail.MailProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;

@Configuration
@EnableConfigurationProperties(value={MailProperties.class})
public class MailConfiguration {
    private final MailProperties mailProperties;

    @Bean
    @Profile(value={"!no-mail"})
    public JavaMailSender getJavaMailSender() throws MessagingException {
        JavaMailSenderImpl mailSender = new JavaMailSenderImpl();
        mailSender.setHost(this.mailProperties.getHost());
        mailSender.setPort(this.mailProperties.getPort().intValue());
        mailSender.setProtocol(this.mailProperties.getProtocol());
        mailSender.setUsername(this.mailProperties.getUsername());
        mailSender.setPassword(this.mailProperties.getPassword());
        Properties props = mailSender.getJavaMailProperties();
        props.putAll((Map<?, ?>)this.mailProperties.getProperties());
        mailSender.setJavaMailProperties(props);
        mailSender.testConnection();
        return mailSender;
    }

    @Bean
    @Profile(value={"no-mail"})
    public JavaMailSender getDummyJavaMailSender() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public MailConfiguration(MailProperties mailProperties) {
        this.mailProperties = mailProperties;
    }
}

