/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.legacy.mailing.domain.service;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.FileCopyUtils;

@Service
public class MailTemplateService {
    private final ResourceLoader resourceLoader;

    public String getMailTemplate() throws IOException {
        Resource resource = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)this.resourceLoader).getResource("classpath:bausteine/mail/template/mail-template.tpl");
        byte[] bytes = this.asString(resource).getBytes(StandardCharsets.UTF_8);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public String getMailTemplateWithLink() throws IOException {
        Resource resource = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)this.resourceLoader).getResource("classpath:bausteine/mail/templatewithlink/mail-template.tpl");
        byte[] bytes = this.asString(resource).getBytes(StandardCharsets.UTF_8);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public Resource getLogo() {
        return ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)this.resourceLoader).getResource("classpath:bausteine/mail/email-logo.png");
    }

    public Resource getLogoByPath(String mailLogoPath) throws IOException {
        return ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)this.resourceLoader).getResource("classpath:" + mailLogoPath);
    }

    private String asString(Resource resource) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(resource.getInputStream(), StandardCharsets.UTF_8);){
            String string = FileCopyUtils.copyToString((Reader)reader);
            return string;
        }
    }

    public MailTemplateService(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }
}

