/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.legacy.mailing.process;

import io.muenchendigital.digiwf.legacy.document.domain.DocumentService;
import io.muenchendigital.digiwf.legacy.mailing.domain.model.Mail;
import io.muenchendigital.digiwf.legacy.mailing.domain.model.MailTemplate;
import io.muenchendigital.digiwf.legacy.mailing.domain.service.MailingService;
import io.muenchendigital.digiwf.legacy.mailing.process.MailingVariables;
import io.muenchendigital.digiwf.legacy.mailing.process.SendMailDelegate;
import java.util.Optional;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.springframework.stereotype.Component;

@Component
public class SendMailTemplateWithLinkDelegate
extends SendMailDelegate {
    public SendMailTemplateWithLinkDelegate(MailingService mailingService, DocumentService documentService) {
        super(mailingService, documentService);
    }

    public void execute(DelegateExecution delegateExecution) throws Exception {
        String subject = (String)MailingVariables.SUBJECT.from((VariableScope)delegateExecution).getLocal();
        String receivers = (String)MailingVariables.RECEIVERS.from((VariableScope)delegateExecution).getLocal();
        String body = (String)MailingVariables.BODY.from((VariableScope)delegateExecution).getLocal();
        Optional replyTo = MailingVariables.REPLY_TO.from((VariableScope)delegateExecution).getLocalOptional();
        String bottomText = (String)MailingVariables.BOTTOM_TEXT.from((VariableScope)delegateExecution).getLocal();
        String linkText = (String)MailingVariables.LINK_TEXT.from((VariableScope)delegateExecution).getLocal();
        String linkUrl = (String)MailingVariables.LINK_URL.from((VariableScope)delegateExecution).getLocal();
        Optional attachmentGuid = MailingVariables.ATTACHMENT_GUID.from((VariableScope)delegateExecution).getLocalOptional();
        Optional attachmentName = MailingVariables.ATTACHMENT_NAME.from((VariableScope)delegateExecution).getLocalOptional();
        MailTemplate mail = ((MailTemplate.MailTemplateBuilder)((MailTemplate.MailTemplateBuilder)((MailTemplate.MailTemplateBuilder)((MailTemplate.MailTemplateBuilder)MailTemplate.builder().body(body.replaceAll("(\r\n|\n\r|\r|\n)", "<br />"))).bottomText(bottomText.replaceAll("(\r\n|\n\r|\r|\n)", "<br />")).link(linkUrl).buttonText(linkText).subject(subject)).receivers(receivers)).replyTo((String)replyTo.orElse(null))).build();
        this.addAttachment(delegateExecution, attachmentGuid, attachmentName, (Mail)mail);
        this.mailingService.sendMailTemplateWithLink(mail);
    }
}

