/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.legacy.shared.data.serialize;

import io.muenchendigital.digiwf.legacy.form.domain.model.FieldTypes;
import io.muenchendigital.digiwf.legacy.form.domain.model.FormField;
import io.muenchendigital.digiwf.legacy.shared.data.serialize.SerializeHandler;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class DateInputSerializeHandler
implements SerializeHandler {
    public Boolean isResponsibleFor(FormField formField) {
        return FieldTypes.TEXT.equals(formField.getType()) && "date".equals(formField.getExt());
    }

    public Map<String, Object> serialize(String key, Object value, FormField field) {
        HashMap<String, Object> serializedVariables = new HashMap<String, Object>();
        serializedVariables.put(key, value);
        if (StringUtils.isBlank((CharSequence)((String)value))) {
            return serializedVariables;
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");
        LocalDate localDate = LocalDate.parse(value.toString());
        serializedVariables.put(key + "__detail_format", formatter.format(localDate));
        return serializedVariables;
    }
}

